/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.works;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.util.StringExtractor;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;

public class WorksExtractor
implements Extractor {
    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        try {
            WorksStringExtractor worksStringExtractor = new WorksStringExtractor();
            String string2 = worksStringExtractor.extract(inputStream).trim();
            if (string2.length() > 0) {
                rDFContainer.add(NIE.plainTextContent, string2);
                rDFContainer.add(RDF.type, (Node)NFO.PaginatedTextDocument);
            }
        }
        catch (IOException iOException) {
            throw new ExtractorException(iOException);
        }
    }

    private static class WorksStringExtractor
    extends StringExtractor {
        private static final int MSWORKS_DOCUMENT = 0;
        private static final int MSWORKS_SPREADSHEET = 1;
        private boolean endOfDocumentReached = false;
        private int okayTrimmedLineCount = 0;
        private int worksType = 0;

        private WorksStringExtractor() {
        }

        protected boolean isTextCharacter(int n) {
            return super.isTextCharacter(n) || n == 0;
        }

        protected boolean isStartLine(String string) {
            if ("gtt".equals(string)) {
                return true;
            }
            return super.isStartLine(string);
        }

        protected boolean isValidLine(String string) {
            if ("microsoft works".equals(string) || "msworkswpdoc".equals(string)) {
                return false;
            }
            return super.isValidLine(string);
        }

        protected String postProcessLine(String string) {
            boolean bl;
            if (this.endOfDocumentReached) {
                return null;
            }
            if (this.okayTrimmedLineCount < 4 && (string.length() == 3 && string.endsWith("&T") || string.startsWith("VT&"))) {
                this.worksType = 1;
                return null;
            }
            if ((string = super.postProcessLine(string)) == null) {
                return null;
            }
            if (this.worksType == 1) {
                if (string.startsWith("@")) {
                    return null;
                }
                if (string.length() < 6 && (string.indexOf(64) >= 0 || this.isAllUppercase(string))) {
                    return null;
                }
            } else if (string.indexOf(0) >= 0) {
                if (this.okayTrimmedLineCount > 5) {
                    this.endOfDocumentReached = true;
                }
                return null;
            }
            boolean bl2 = bl = string.length() > 2 && !Character.isWhitespace(string.charAt(1)) && string.charAt(1) != '\u0000';
            if (bl) {
                ++this.okayTrimmedLineCount;
                if (this.worksType == 1) {
                    string = string.replace('\u0000', ' ');
                }
                return string;
            }
            return null;
        }

        private boolean isAllUppercase(String string) {
            int n = string.length();
            while (n-- > 0) {
                char c = string.charAt(n);
                if (!Character.isLetter(c) || Character.isUpperCase(c)) continue;
                return false;
            }
            return true;
        }
    }
}

