/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.opener.http;

import java.io.IOException;
import java.lang.reflect.Method;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.semanticdesktop.aperture.opener.DataOpener;
import org.semanticdesktop.aperture.util.OSUtils;

public class HttpOpener
implements DataOpener {
    public void open(URI uRI) throws IOException {
        if (OSUtils.isMac()) {
            this.macopen(uRI);
        } else if (OSUtils.isLinux()) {
            this.linuxopen(uRI);
        } else if (OSUtils.isWindows()) {
            this.windowsopen(uRI);
        } else {
            throw new IOException("Unsupported OS:" + System.getProperty("os.name"));
        }
    }

    private void windowsopen(URI uRI) throws IOException {
        Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", uRI.toString()});
    }

    private void linuxopen(URI uRI) throws IOException {
        if (System.getenv("DESKTOP_SESSION").toLowerCase().contains("kde")) {
            Runtime.getRuntime().exec(new String[]{"kfmclient", "exec", uRI.toString()});
        } else {
            Runtime.getRuntime().exec(new String[]{"gnome-open", uRI.toString()});
        }
    }

    private void macopen(URI uRI) throws IOException {
        try {
            Class<?> clazz = Class.forName("com.apple.eio.FileManager");
            Method method = clazz.getMethod("openURL", String.class);
            method.invoke(null, uRI.toString());
        }
        catch (Exception exception) {
            throw new IOException("Could not open URI: " + uRI + " - " + exception);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        HttpOpener httpOpener = new HttpOpener();
        httpOpener.open(URIImpl.createURIWithoutChecking((String)"http://www.google.com"));
    }
}

