/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.Logger;
import org.modeshape.connector.meta.jdbc.JdbcMetadataI18n;
import org.modeshape.connector.meta.jdbc.JdbcMetadataLexicon;
import org.modeshape.connector.meta.jdbc.JdbcMetadataSource;
import org.modeshape.connector.meta.jdbc.JdbcMetadataWorkspace;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.PathNode;
import org.modeshape.graph.connector.base.PathTransaction;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.request.InvalidWorkspaceException;

@ThreadSafe
public class JdbcMetadataRepository
extends Repository<PathNode, JdbcMetadataWorkspace> {
    public static final String TABLES_SEGMENT_NAME = "tables";
    public static final String PROCEDURES_SEGMENT_NAME = "procedures";
    private static final Logger LOGGER = Logger.getLogger(JdbcMetadataRepository.class);
    private final JdbcMetadataSource source;
    private Map<Name, Property> rootNodeProperties;
    private String databaseProductName;
    private String databaseProductVersion;
    private int databaseMajorVersion;
    private int databaseMinorVersion;

    public JdbcMetadataRepository(JdbcMetadataSource source) {
        super((BaseRepositorySource)source);
        this.source = source;
        this.initialize();
    }

    final JdbcMetadataSource source() {
        return this.source;
    }

    protected synchronized void initialize() {
        ExecutionContext context = this.source.getRepositoryContext().getExecutionContext();
        PropertyFactory propFactory = context.getPropertyFactory();
        this.rootNodeProperties = new HashMap<Name, Property>();
        Connection conn = this.getConnection();
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            this.databaseProductName = dmd.getDatabaseProductName();
            this.databaseProductVersion = dmd.getDatabaseProductVersion();
            this.databaseMajorVersion = dmd.getDatabaseMajorVersion();
            this.databaseMinorVersion = dmd.getDatabaseMinorVersion();
            Name propName = JdbcMetadataLexicon.DATABASE_PRODUCT_NAME;
            this.rootNodeProperties.put(propName, propFactory.create(propName, new Object[]{this.databaseProductName}));
            propName = JdbcMetadataLexicon.DATABASE_PRODUCT_VERSION;
            this.rootNodeProperties.put(propName, propFactory.create(propName, new Object[]{this.databaseProductVersion}));
            propName = JdbcMetadataLexicon.DATABASE_MAJOR_VERSION;
            this.rootNodeProperties.put(propName, propFactory.create(propName, new Object[]{this.databaseMajorVersion}));
            propName = JdbcMetadataLexicon.DATABASE_MINOR_VERSION;
            this.rootNodeProperties.put(propName, propFactory.create(propName, new Object[]{this.databaseMinorVersion}));
            this.rootNodeProperties.put(JcrLexicon.PRIMARY_TYPE, propFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.ROOT}));
            this.rootNodeProperties.put(JcrLexicon.MIXIN_TYPES, propFactory.create(JcrLexicon.MIXIN_TYPES, new Object[]{JdbcMetadataLexicon.DATABASE_ROOT}));
            this.rootNodeProperties = Collections.unmodifiableMap(this.rootNodeProperties);
        }
        catch (SQLException se) {
            throw new IllegalStateException(JdbcMetadataI18n.couldNotGetDatabaseMetadata.text(new Object[0]), se);
        }
        finally {
            this.closeConnection(conn);
        }
        super.initialize();
    }

    Connection getConnection() {
        try {
            return this.source.getDataSource().getConnection();
        }
        catch (SQLException se) {
            throw new IllegalStateException(JdbcMetadataI18n.errorObtainingConnection.text(new Object[0]), se);
        }
    }

    void closeConnection(Connection connection) {
        assert (connection != null);
        try {
            connection.close();
        }
        catch (SQLException se) {
            LOGGER.error((Throwable)se, JdbcMetadataI18n.errorClosingConnection, new Object[0]);
        }
    }

    final Map<Name, Property> rootNodeProperties() {
        return this.rootNodeProperties;
    }

    public JdbcMetadataTransaction startTransaction(ExecutionContext context, boolean readonly) {
        return new JdbcMetadataTransaction(this, this.source.getRootNodeUuidObject());
    }

    @NotThreadSafe
    protected class JdbcMetadataTransaction
    extends PathTransaction<PathNode, JdbcMetadataWorkspace> {
        public JdbcMetadataTransaction(Repository<PathNode, JdbcMetadataWorkspace> repository, UUID rootNodeUuid) {
            super(repository, rootNodeUuid);
        }

        protected PathNode createNode(Path.Segment name, Path parentPath, Iterable<Property> properties) {
            throw new RepositorySourceException(JdbcMetadataI18n.sourceIsReadOnly.text(new Object[]{JdbcMetadataRepository.this.source().getName()}));
        }

        public boolean destroyWorkspace(JdbcMetadataWorkspace workspace) throws InvalidWorkspaceException {
            throw new RepositorySourceException(JdbcMetadataI18n.sourceIsReadOnly.text(new Object[]{JdbcMetadataRepository.this.source().getName()}));
        }

        public JdbcMetadataWorkspace getWorkspace(String name, JdbcMetadataWorkspace originalToClone) throws InvalidWorkspaceException {
            if (name.equals(JdbcMetadataRepository.this.source().getDefaultWorkspaceName())) {
                return new JdbcMetadataWorkspace(JdbcMetadataRepository.this, name);
            }
            throw new InvalidWorkspaceException(JdbcMetadataI18n.sourceIsReadOnly.text(new Object[]{JdbcMetadataRepository.this.source().getName()}));
        }
    }
}

