/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import org.semanticdesktop.aperture.util.StringUtil;

public class XmlWriter {
    private static final char[] LINE_SEPARATOR = System.getProperty("line.separator").toCharArray();
    private Writer writer;
    private String charEncoding;
    private boolean prettyPrint = false;
    private int indentLevel = 0;
    private char[] indentString = "\t".toCharArray();
    private ArrayList attNames = new ArrayList();
    private HashMap attValues = new HashMap();

    public XmlWriter(Writer writer) {
        this.writer = writer;
    }

    public XmlWriter(OutputStream outputStream) {
        try {
            this.charEncoding = "UTF-8";
            this.writer = new OutputStreamWriter(outputStream, this.charEncoding);
            this.writer = new BufferedWriter(this.writer);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 character encoding not supported on this platform");
        }
    }

    public XmlWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.charEncoding = string;
        this.writer = new OutputStreamWriter(outputStream, string);
        this.writer = new BufferedWriter(this.writer);
    }

    public void setPrettyPrint(boolean bl) {
        this.prettyPrint = bl;
    }

    public boolean prettyPrintEnabled() {
        return this.prettyPrint;
    }

    public void setIndentString(String string) {
        this.indentString = string.toCharArray();
    }

    public String getIndentString() {
        return new String(this.indentString);
    }

    public void startDocument() throws IOException {
        this.writer.write("<?xml version='1.0'");
        if (this.charEncoding != null) {
            this.writer.write(" encoding='");
            this.writer.write(this.charEncoding);
            this.writer.write(39);
        }
        this.writer.write("?>");
        this.writeLn();
    }

    public void endDocument() throws IOException {
        this.writer.flush();
        this.writer = null;
    }

    public void setAttribute(String string, String string2) {
        this.attNames.add(string);
        this.attValues.put(string, string2);
    }

    public void setAttribute(String string, int n) {
        this.setAttribute(string, String.valueOf(n));
    }

    public void setAttribute(String string, long l) {
        this.setAttribute(string, String.valueOf(l));
    }

    public void setAttribute(String string, boolean bl) {
        this.setAttribute(string, String.valueOf(bl));
    }

    public void startTag(String string) throws IOException {
        this.writeIndent();
        this.writer.write(60);
        this.writer.write(string);
        this.writeAtts();
        this.writer.write(62);
        this.writeLn();
        ++this.indentLevel;
    }

    public void endTag(String string) throws IOException {
        --this.indentLevel;
        this.writeIndent();
        this.writer.write("</");
        this.writer.write(string);
        this.writer.write(62);
        this.writeLn();
    }

    public void emptyElement(String string) throws IOException {
        this.writeIndent();
        this.writer.write(60);
        this.writer.write(string);
        this.writeAtts();
        this.writer.write("/>");
        this.writeLn();
    }

    public void textElement(String string, String string2) throws IOException {
        this.writeIndent();
        this.writer.write(60);
        this.writer.write(string);
        this.writeAtts();
        this.writer.write(62);
        this.text(string2);
        this.writer.write("</");
        this.writer.write(string);
        this.writer.write(62);
        this.writeLn();
    }

    public void textElement(String string, int n) throws IOException {
        this.textElement(string, String.valueOf(n));
    }

    public void textElement(String string, long l) throws IOException {
        this.textElement(string, String.valueOf(l));
    }

    public void textElement(String string, boolean bl) throws IOException {
        this.textElement(string, String.valueOf(bl));
    }

    public void text(String string) throws IOException {
        string = StringUtil.replace("&", "&amp;", string);
        string = StringUtil.replace("<", "&lt;", string);
        string = StringUtil.replace("]]>", "]]&gt;", string);
        this.writer.write(string);
    }

    public void comment(String string) throws IOException {
        this.writeIndent();
        this.writer.write("<!-- ");
        this.writer.write(string);
        this.writer.write(" -->");
        this.writeLn();
    }

    public void emptyLine() throws IOException {
        this.writeLn();
    }

    private void writeAtts() throws IOException {
        int n = this.attNames.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.attNames.get(i);
            String string2 = (String)this.attValues.get(string);
            this.writer.write(32);
            this.writer.write(string);
            this.writer.write("='");
            if (string2 != null) {
                string2 = StringUtil.replace("&", "&amp;", string2);
                string2 = StringUtil.replace("<", "&lt;", string2);
                string2 = StringUtil.replace("'", "&apos;", string2);
                this.writer.write(string2);
            }
            this.writer.write(39);
        }
        this.attNames.clear();
        this.attValues.clear();
    }

    private final void writeLn() throws IOException {
        if (this.prettyPrint) {
            this.writer.write(LINE_SEPARATOR);
        }
    }

    private final void writeIndent() throws IOException {
        if (this.prettyPrint) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.writer.write(this.indentString);
            }
        }
    }
}

