/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.websites.bibsonomy;

import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.datasource.base.DataSourceBase;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;
import org.semanticdesktop.aperture.websites.bibsonomy.BIBSONOMYDS;

public class BibsonomyDataSource
extends DataSourceBase {
    public URI getType() {
        return BIBSONOMYDS.BibsonomyDataSource;
    }

    public String getUsername() {
        return this.getConfiguration().getString(DATASOURCE.username);
    }

    public void setUsername(String string) {
        if (string == null) {
            this.getConfiguration().remove(DATASOURCE.username);
        } else {
            this.getConfiguration().put(DATASOURCE.username, string);
        }
    }

    public CrawlType getCrawlType() {
        return CrawlType.fromUri(this.getConfiguration().getURI(BIBSONOMYDS.crawlType));
    }

    public void setCrawlType(CrawlType crawlType) {
        if (crawlType == null) {
            this.getConfiguration().remove(BIBSONOMYDS.crawlType);
        } else {
            this.getConfiguration().put(BIBSONOMYDS.crawlType, (Node)crawlType.toUri());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CrawlType {
        ItemsAndTagsCrawlType,
        ItemsOnlyCrawlType;


        public static CrawlType fromUri(URI uRI) {
            if (uRI == null) {
                return null;
            }
            if (uRI.equals(BIBSONOMYDS.ItemsAndTagsCrawlType)) {
                return ItemsAndTagsCrawlType;
            }
            if (uRI.equals(BIBSONOMYDS.ItemsOnlyCrawlType)) {
                return ItemsOnlyCrawlType;
            }
            return null;
        }

        public URI toUri() {
            if (this.equals((Object)ItemsAndTagsCrawlType)) {
                return BIBSONOMYDS.ItemsAndTagsCrawlType;
            }
            if (this.equals((Object)ItemsOnlyCrawlType)) {
                return BIBSONOMYDS.ItemsOnlyCrawlType;
            }
            return null;
        }
    }
}

