/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.config;

import org.ontoware.rdf2go.model.node.Node;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;

public abstract class SubstringCondition {
    public static final StartsWith STARTS_WITH = new StartsWith();
    public static final EndsWith ENDS_WITH = new EndsWith();
    public static final Contains CONTAINS = new Contains();
    public static final DoesNotContain DOES_NOT_CONTAIN = new DoesNotContain();

    public abstract boolean test(String var1, String var2);

    public abstract Node toNode();

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof SubstringCondition) {
            SubstringCondition substringCondition = (SubstringCondition)object;
            bl = this.toString().equals(substringCondition.toString());
        }
        return bl;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static class DoesNotContain
    extends SubstringCondition {
        public String toString() {
            return "DoesNotContain";
        }

        public boolean test(String string, String string2) {
            return string.indexOf(string2) < 0;
        }

        public Node toNode() {
            return DATASOURCE.DOES_NOT_CONTAIN;
        }
    }

    public static class Contains
    extends SubstringCondition {
        public String toString() {
            return "Contains";
        }

        public boolean test(String string, String string2) {
            return string.indexOf(string2) >= 0;
        }

        public Node toNode() {
            return DATASOURCE.CONTAINS;
        }
    }

    public static class EndsWith
    extends SubstringCondition {
        public String toString() {
            return "EndsWith";
        }

        public boolean test(String string, String string2) {
            return string.endsWith(string2);
        }

        public Node toNode() {
            return DATASOURCE.ENDS_WITH;
        }
    }

    public static class StartsWith
    extends SubstringCondition {
        public String toString() {
            return "StartsWith";
        }

        public boolean test(String string, String string2) {
            return string.startsWith(string2);
        }

        public Node toNode() {
            return DATASOURCE.STARTS_WITH;
        }
    }
}

