/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.StringTokenizer;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.UriUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfExtractor
implements Extractor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        PDDocument pDDocument = null;
        try {
            try {
                PDFParser pDFParser = new PDFParser(inputStream);
                pDFParser.parse();
                pDDocument = pDFParser.getPDDocument();
            }
            catch (IOException iOException) {
                throw new ExtractorException(iOException);
            }
            this.processDocument(uRI, pDDocument, rDFContainer);
        }
        finally {
            if (pDDocument != null) {
                try {
                    pDDocument.close();
                }
                catch (IOException iOException) {
                    throw new ExtractorException(iOException);
                }
            }
        }
    }

    private void processDocument(URI uRI, PDDocument pDDocument, RDFContainer rDFContainer) throws ExtractorException {
        PDFTextStripper pDFTextStripper;
        if (pDDocument.isEncrypted()) {
            try {
                this.logger.info("Trying to decrypt " + uRI);
                pDDocument.decrypt("");
                this.logger.info("Decryption succeeded");
            }
            catch (CryptographyException cryptographyException) {
                throw new ExtractorException(cryptographyException);
            }
            catch (IOException iOException) {
                throw new ExtractorException(iOException);
            }
            catch (InvalidPasswordException invalidPasswordException) {
                this.logger.info("Decryption failed", (Throwable)invalidPasswordException);
            }
        }
        try {
            pDFTextStripper = new PDFTextStripper();
            String string = pDFTextStripper.getText(pDDocument);
            if (string != null) {
                rDFContainer.add(NIE.plainTextContent, string);
            }
        }
        catch (IOException iOException) {
            this.logger.warn("IOException while extracting full-text of " + uRI, (Throwable)iOException);
        }
        pDFTextStripper = pDDocument.getDocumentInformation();
        try {
            this.addContactStatement(NCO.creator, pDFTextStripper.getAuthor(), rDFContainer);
        }
        catch (Exception exception) {
            this.logger.warn("Exception while extracting author of " + uRI, (Throwable)exception);
        }
        try {
            this.addStringMetadata(NIE.title, pDFTextStripper.getTitle(), rDFContainer);
        }
        catch (Exception exception) {
            this.logger.warn("Exception while extracting title of " + uRI, (Throwable)exception);
        }
        try {
            this.addStringMetadata(NIE.subject, pDFTextStripper.getSubject(), rDFContainer);
        }
        catch (Exception exception) {
            this.logger.warn("Exception while extracting subject of " + uRI, (Throwable)exception);
        }
        try {
            this.addStringMetadata(NIE.generator, pDFTextStripper.getCreator(), rDFContainer);
        }
        catch (Exception exception) {
            this.logger.warn("Exception while extracting creator of " + uRI, (Throwable)exception);
        }
        try {
            this.addStringMetadata(NIE.generator, pDFTextStripper.getProducer(), rDFContainer);
        }
        catch (Exception exception) {
            this.logger.warn("Exception while extracting producer of " + uRI, (Throwable)exception);
        }
        try {
            this.addCalendarMetadata(NIE.contentCreated, pDFTextStripper.getCreationDate(), rDFContainer);
        }
        catch (Exception exception) {
            this.logger.warn("Exception while extracting creation date of " + uRI, (Throwable)exception);
        }
        try {
            this.addCalendarMetadata(NIE.contentLastModified, pDFTextStripper.getModificationDate(), rDFContainer);
        }
        catch (Exception exception) {
            this.logger.warn("Exception while extracting modification date of " + uRI, (Throwable)exception);
        }
        try {
            int n = pDDocument.getNumberOfPages();
            if (n >= 0) {
                rDFContainer.add(RDF.type, (Node)NFO.PaginatedTextDocument);
                rDFContainer.add(NFO.pageCount, n);
            }
        }
        catch (Exception exception) {
            this.logger.warn("Exception while extracting number of pages of " + uRI, (Throwable)exception);
        }
        try {
            String string = pDFTextStripper.getKeywords();
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t,;'\"|", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2 == null) continue;
                    rDFContainer.add(NIE.keyword, string2);
                }
            }
        }
        catch (Exception exception) {
            this.logger.warn("Exception while extracting keywords of " + uRI, (Throwable)exception);
        }
    }

    private void addStringMetadata(URI uRI, String string, RDFContainer rDFContainer) {
        if (string != null) {
            rDFContainer.add(uRI, string);
        }
    }

    private void addCalendarMetadata(URI uRI, Calendar calendar, RDFContainer rDFContainer) {
        if (calendar != null) {
            rDFContainer.add(uRI, calendar);
        }
    }

    private void addContactStatement(URI uRI, String string, RDFContainer rDFContainer) {
        if (string != null) {
            Model model = rDFContainer.getModel();
            Resource resource = UriUtil.generateRandomResource(model);
            model.addStatement(resource, RDF.type, (Node)NCO.Contact);
            model.addStatement(resource, NCO.fullname, string);
            rDFContainer.add(uRI, (Node)resource);
        }
    }
}

