/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.outlook;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComFailException;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.outlook.OutlookCrawler;
import org.semanticdesktop.aperture.outlook.VariantDate;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.ValueFactory;
import org.semanticdesktop.aperture.util.DateUtil;
import org.semanticdesktop.aperture.util.UriUtil;
import org.semanticdesktop.aperture.vocabulary.NCAL;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.semanticdesktop.aperture.vocabulary.NMO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OutlookResource {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private OutlookCrawler crawler;
    private String itemType;
    private Dispatch resource = null;
    private String uri;

    private static String createUri(OutlookCrawler outlookCrawler, Dispatch dispatch, String string) {
        if (outlookCrawler == null) {
            throw new RuntimeException("passed in a null crawler for createUri");
        }
        if (dispatch == null) {
            throw new RuntimeException("passed in a null resource for createUri");
        }
        return outlookCrawler.getUriPrefix() + string + "/" + Dispatch.get((Dispatch)dispatch, (String)"EntryID").getString();
    }

    public static OutlookResource createWrapperFor(OutlookCrawler outlookCrawler, Dispatch dispatch, Logger logger) {
        try {
            int n = Dispatch.get((Dispatch)dispatch, (String)"Class").toInt();
            switch (n) {
                case 26: {
                    return new Appointment(outlookCrawler, dispatch);
                }
                case 40: {
                    return new Contact(outlookCrawler, dispatch);
                }
                case 69: {
                    return new DistList(outlookCrawler, dispatch);
                }
                case 41: {
                    return new Document(outlookCrawler, dispatch);
                }
                case 2: {
                    return OutlookResource.createWrapperForFolder(outlookCrawler, dispatch);
                }
                case 43: {
                    return new Mail(outlookCrawler, dispatch);
                }
                case 1: {
                    return new RootFolder(outlookCrawler);
                }
                case 44: {
                    return new Note(outlookCrawler, dispatch);
                }
                case 48: {
                    return new Task(outlookCrawler, dispatch);
                }
                case 42: {
                    return null;
                }
                case 53: {
                    return null;
                }
                case 0: {
                    return null;
                }
            }
            throw new UrlNotFoundException("no RDF mapping defined for Outlook.classID '" + Integer.toString(n) + "'. Item Ignored.");
        }
        catch (UrlNotFoundException urlNotFoundException) {
            logger.info("Outlook Cannot wrap resource: " + urlNotFoundException);
            return null;
        }
        catch (Exception exception) {
            logger.warn("Error creating Resourcewrapper: " + exception);
            return null;
        }
    }

    public static OutlookResource createWrapperFor(OutlookCrawler outlookCrawler, String string, Logger logger) {
        block11: {
            String string2;
            String string3;
            Dispatch dispatch;
            String string4;
            String string5 = outlookCrawler.getUriPrefix();
            try {
                if (!string.startsWith(string5)) {
                    throw new Exception("uri '" + string + "' is not starting with '" + string5 + "'");
                }
                string4 = string.substring(string5.length());
                dispatch = string4.split("/");
                string3 = dispatch[0];
                string2 = ((String[])dispatch).length > 1 ? dispatch[1] : null;
            }
            catch (Exception exception) {
                if (logger.isInfoEnabled()) {
                    logger.info("uri '" + string + "' cannot be parsed." + exception.toString());
                }
                return null;
            }
            try {
                if (string3.equals(Appointment.ITEMTYPE) || string3.equals("contact") || string3.equals("distlist") || string3.equals("document") || string3.equals("mail") || string3.equals("note") || string3.equals("task")) {
                    string4 = Dispatch.call((Dispatch)outlookCrawler.getOutlookMapi(), (String)"GetItemFromID", (Object)string2);
                    if (string4 == null) {
                        throw new Exception("GetItemFromID returned null for id " + string2);
                    }
                    dispatch = string4.toDispatch();
                    OutlookResource outlookResource = OutlookResource.createWrapperFor(outlookCrawler, dispatch, logger);
                    return outlookResource;
                }
                if (string3.equals("root")) {
                    return new RootFolder(outlookCrawler);
                }
                if (string3.equals("folder") || string3.equals("calendar")) {
                    return OutlookResource.createWrapperForFolder(outlookCrawler, string2, string3, logger);
                }
            }
            catch (ComFailException comFailException) {
                outlookCrawler.crashChecker(comFailException);
            }
            catch (Exception exception) {
                if (!logger.isInfoEnabled()) break block11;
                logger.info("Cannot resolve outlook uri '" + string + "': " + exception.toString(), (Throwable)exception);
            }
        }
        return null;
    }

    public static Folder createWrapperForFolder(OutlookCrawler outlookCrawler, Dispatch dispatch) {
        int n = Dispatch.get((Dispatch)dispatch, (String)"DefaultItemType").toInt();
        if (n == 1) {
            return new Calendar(outlookCrawler, dispatch);
        }
        return new Folder(outlookCrawler, dispatch);
    }

    public static Folder createWrapperForFolder(OutlookCrawler outlookCrawler, String string, String string2, Logger logger) throws Exception {
        Variant variant = Dispatch.call((Dispatch)outlookCrawler.getOutlookMapi(), (String)"GetItemFromID", (Object)string);
        if (variant == null) {
            throw new Exception("GetItemFromID returned null for id " + string);
        }
        Dispatch dispatch = variant.toDispatch();
        Folder folder = OutlookResource.createWrapperForFolder(outlookCrawler, dispatch);
        if (!string2.equals(folder.getItemType())) {
            String string3 = "created wrapper for item " + string + "  expected " + string2 + " but got " + folder.getItemType();
            logger.warn(string3);
            throw new Exception(string3);
        }
        return folder;
    }

    protected OutlookResource(OutlookCrawler outlookCrawler, Dispatch dispatch, String string) {
        this(outlookCrawler, OutlookResource.createUri(outlookCrawler, dispatch, string), dispatch, string);
    }

    protected OutlookResource(OutlookCrawler outlookCrawler, String string, Dispatch dispatch, String string2) {
        if (outlookCrawler == null) {
            throw new RuntimeException("crawler must not be null for OutlookResource");
        }
        this.crawler = outlookCrawler;
        this.uri = string;
        this.resource = dispatch;
        this.itemType = string2;
    }

    protected abstract void addData(RDFContainer var1) throws IOException;

    protected void addDateIfNotNull(RDFContainer rDFContainer, URI uRI, Dispatch dispatch, String string) {
        Date date = this.getDateOf(dispatch, string);
        if (date != null) {
            rDFContainer.add(uRI, date);
        }
    }

    protected void addNcalDateTimeIfNotNull(RDFContainer rDFContainer, URI uRI, Dispatch dispatch, String string) {
        Date date = this.getDateOf(dispatch, string);
        if (date != null) {
            Resource resource = UriUtil.generateRandomResource(rDFContainer.getModel());
            rDFContainer.add(uRI, (Node)resource);
            this.addStatement(rDFContainer, resource, RDF.type, (Node)NCAL.NcalDateTime);
            this.addStatement(rDFContainer, resource, NCAL.dateTime, DateUtil.dateTime2String(date), XSD._dateTime);
        }
    }

    protected void addEmailAddressIfNotNull(Model model, Resource resource, Dispatch dispatch, String string) {
        String string2 = this.getLiteralOf(dispatch, string);
        if (string2 != null) {
            Resource resource2 = UriUtil.generateRandomResource(model);
            model.addStatement(resource, NCO.hasEmailAddress, (Node)resource2);
            model.addStatement(resource2, RDF.type, (Node)NCO.EmailAddress);
            model.addStatement(resource2, NCO.emailAddress, string2);
        }
    }

    protected void addTelephoneNumberIfNotNull(Model model, Resource resource, Dispatch dispatch, String string, String string2, URI uRI) {
        String string3 = this.getLiteralOf(dispatch, string);
        if (string3 != null) {
            Resource resource2 = UriUtil.generateRandomResource(model);
            model.addStatement(resource, NCO.hasPhoneNumber, (Node)resource2);
            model.addStatement(resource2, RDF.type, (Node)uRI);
            model.addStatement(resource2, NCO.phoneNumber, string3);
            if (string2 != null) {
                model.addStatement(resource2, NCO.contactMediumComment, string2);
            }
        }
    }

    protected void addPropertyIfNotNull(RDFContainer rDFContainer, URI uRI, Dispatch dispatch, String string) {
        String string2 = this.getLiteralOf(dispatch, string);
        if (string2 != null) {
            rDFContainer.add(uRI, string2);
        }
    }

    protected void addStatement(RDFContainer rDFContainer, Resource resource, URI uRI, String string, URI uRI2) {
        this.addStatement(rDFContainer, resource, uRI, (Node)rDFContainer.getModel().createDatatypeLiteral(string, uRI2));
    }

    protected void addStatement(RDFContainer rDFContainer, Resource resource, URI uRI, String string) {
        this.addStatement(rDFContainer, resource, uRI, (Node)rDFContainer.getModel().createPlainLiteral(string));
    }

    protected void addStatement(RDFContainer rDFContainer, Resource resource, URI uRI, Node node) {
        rDFContainer.getModel().addStatement(resource, uRI, node);
    }

    protected void addRecipientsIfNotNull(RDFContainer rDFContainer, Dispatch dispatch, String string, OutlookResource outlookResource) {
        if (outlookResource == null) {
            throw new NullPointerException("Error: parentResource=null");
        }
        Variant variant = Dispatch.get((Dispatch)dispatch, (String)string);
        ValueFactory valueFactory = rDFContainer.getValueFactory();
        if (variant != null) {
            Dispatch dispatch2 = variant.toDispatch();
            int n = Dispatch.get((Dispatch)dispatch2, (String)"Count").toInt();
            this.logger.info("adding e-mail, found recipients: " + n);
            for (int i = 1; i <= n; ++i) {
                try {
                    Dispatch dispatch3 = Dispatch.invoke((Dispatch)dispatch2, (String)"Item", (int)2, (Object[])new Object[]{new Integer(i)}, (int[])new int[1]).toDispatch();
                    String string2 = this.getLiteralOf(dispatch3, "Type");
                    String string3 = this.getLiteralOf(dispatch3, "Name");
                    String string4 = this.getLiteralOf(dispatch3, "Address");
                    if (string3 == null && string4 == null) continue;
                    URI uRI = valueFactory.createURI(this.getUri() + "_recipient" + i);
                    rDFContainer.add(valueFactory.createStatement((Resource)uRI, RDF.type, (Node)NCO.Contact));
                    if (string3 != null) {
                        rDFContainer.add(valueFactory.createStatement((Resource)uRI, NCO.fullname, (Node)valueFactory.createLiteral(string3)));
                    }
                    if (string4 != null) {
                        Resource resource = UriUtil.generateRandomResource(rDFContainer.getModel());
                        this.addStatement(rDFContainer, (Resource)uRI, NCO.hasEmailAddress, (Node)resource);
                        this.addStatement(rDFContainer, resource, RDF.type, (Node)NCO.EmailAddress);
                        this.addStatement(rDFContainer, resource, NCO.emailAddress, (Node)valueFactory.createLiteral(string4));
                    }
                    if (outlookResource instanceof Mail) {
                        if (string2.equals(Integer.toString(1))) {
                            rDFContainer.add(NMO.to, (Node)uRI);
                            continue;
                        }
                        if (string2.equals(Integer.toString(2))) {
                            rDFContainer.add(NMO.cc, (Node)uRI);
                            continue;
                        }
                        if (string2.equals(Integer.toString(3))) {
                            rDFContainer.add(NMO.bcc, (Node)uRI);
                            continue;
                        }
                        this.logger.warn("cannot connect mail recipient type '" + string2 + "', using NMO.to instead");
                        rDFContainer.add(NMO.to, (Node)uRI);
                        continue;
                    }
                    if (outlookResource instanceof Appointment) {
                        if (string2.equals(Integer.toString(2))) {
                            rDFContainer.add(NCAL.attendee, (Node)uRI);
                            rDFContainer.add(valueFactory.createStatement((Resource)uRI, RDF.type, (Node)NCAL.Attendee));
                            rDFContainer.add(valueFactory.createStatement((Resource)uRI, NCAL.role, (Node)NCAL.optParticipantRole));
                            continue;
                        }
                        if (string2.equals(Integer.toString(0))) {
                            rDFContainer.add(NCAL.attendee, (Node)uRI);
                            rDFContainer.add(NCAL.organizer, (Node)uRI);
                            rDFContainer.add(valueFactory.createStatement((Resource)uRI, RDF.type, (Node)NCAL.Attendee));
                            rDFContainer.add(valueFactory.createStatement((Resource)uRI, RDF.type, (Node)NCAL.Organizer));
                            rDFContainer.add(valueFactory.createStatement((Resource)uRI, NCAL.role, (Node)NCAL.chairRole));
                            continue;
                        }
                        if (string2.equals(Integer.toString(1))) {
                            rDFContainer.add(NCAL.attendee, (Node)uRI);
                            rDFContainer.add(valueFactory.createStatement((Resource)uRI, RDF.type, (Node)NCAL.Attendee));
                            rDFContainer.add(valueFactory.createStatement((Resource)uRI, NCAL.role, (Node)NCAL.reqParticipantRole));
                            continue;
                        }
                        if (string2.equals(Integer.toString(3))) {
                            rDFContainer.add(NCAL.attendee, (Node)uRI);
                            rDFContainer.add(valueFactory.createStatement((Resource)uRI, RDF.type, (Node)NCAL.Attendee));
                            rDFContainer.add(valueFactory.createStatement((Resource)uRI, RDFS.comment, (Node)valueFactory.createLiteral("resource")));
                            continue;
                        }
                        this.logger.warn("cannot connect Appointment recipient type '" + string2 + "', using NCAL.attendee instead");
                        rDFContainer.add(NCAL.attendee, (Node)uRI);
                        rDFContainer.add(valueFactory.createStatement((Resource)uRI, RDF.type, (Node)NCAL.Attendee));
                        continue;
                    }
                    this.logger.warn("cannot add recipients for type '" + outlookResource.getClass() + "': I only understand OutlookResource.Appointment or OutlookResource.Mail. " + "Using connection NIE:hasLogicalPart to connect " + rDFContainer.getDescribedUri() + " to " + uRI);
                    rDFContainer.add(NIE.hasLogicalPart, (Node)uRI);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.resource != null) {
            this.logger.warn("This resource was not released, but in finalize: " + this.getUri());
            this.release();
        }
        super.finalize();
    }

    public DataObject getDataObjectIfModified(String string, DataSource dataSource, AccessData accessData, Map map, RDFContainerFactory rDFContainerFactory) throws UrlNotFoundException, IOException {
        return null;
    }

    protected Date getDateOf(Dispatch dispatch, String string) {
        try {
            Variant variant = Dispatch.get((Dispatch)dispatch, (String)string);
            if (variant == null || variant.isNull()) {
                return null;
            }
            if (variant.getvt() == 7) {
                VariantDate variantDate = new VariantDate(variant.toDate());
                Date date = variantDate.getDate();
                return date;
            }
            throw new RuntimeException("cannot read " + string + " from dispatch, does not return a Date-Value");
        }
        catch (ComFailException comFailException) {
            this.logger.warn("Error on com for dispname " + string + ": " + (Object)((Object)comFailException));
            return null;
        }
    }

    public String getItemType() {
        return this.itemType;
    }

    public long getLastModified() {
        Variant variant;
        try {
            variant = Dispatch.get((Dispatch)this.resource, (String)"LastModificationTime");
        }
        catch (ComFailException comFailException) {
            this.logger.warn("cannot read last-modification time of " + this.getUri() + " of type " + this.getItemType());
            return 0L;
        }
        if (variant == null || variant.isNull()) {
            this.logger.warn("cannot read LastModificationTime, no value");
            return 0L;
        }
        if (variant.getvt() == 7) {
            double d = variant.getDate();
            VariantDate variantDate = new VariantDate(variant.toDate());
            if (this.logger.isInfoEnabled()) {
                this.logger.info("This has lastModified: " + DateUtil.dateTime2String(variantDate.getDate()) + " with double " + Double.toString(d));
            }
            return variantDate.getDate().getTime();
        }
        this.logger.warn("cannot read LastModificationTime, type is not date but: " + variant.getvt());
        return 0L;
    }

    protected String getLiteralOf(Dispatch dispatch, String string) {
        try {
            String string2 = null;
            Variant variant = Dispatch.get((Dispatch)dispatch, (String)string);
            if (variant == null || variant.isNull()) {
                string2 = null;
            } else if (variant.getvt() == 7) {
                VariantDate variantDate = new VariantDate(variant.toDate());
                Date date = variantDate.getDate();
                string2 = DateUtil.dateTime2String(date);
            } else {
                string2 = variant.toString();
            }
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            return string2;
        }
        catch (ComFailException comFailException) {
            this.logger.warn("Error on com for dispname " + string + ": " + (Object)((Object)comFailException));
            return null;
        }
    }

    public OutlookCrawler getOLCrawler() {
        return this.crawler;
    }

    public Dispatch getResource() {
        return this.resource;
    }

    public abstract URI getType();

    public String getUri() {
        return this.uri;
    }

    public boolean isFolder() {
        return false;
    }

    public void release() {
        if (this.resource != null) {
            this.resource.safeRelease();
        }
        this.resource = null;
    }

    public static class Task
    extends OutlookResourceSave {
        public static final String ITEMTYPE = "task";

        public Task(OutlookCrawler outlookCrawler, Dispatch dispatch) {
            super(outlookCrawler, dispatch, ITEMTYPE);
            this.saveRedemptionClass = "Redemption.SafeTaskItem";
        }

        protected void addData(RDFContainer rDFContainer) throws IOException {
            Dispatch dispatch = this.getSaveResource();
            this.addPropertyIfNotNull(rDFContainer, NIE.title, dispatch, "Subject");
            this.addPropertyIfNotNull(rDFContainer, NIE.plainTextContent, dispatch, "Body");
            this.addDateIfNotNull(rDFContainer, NCAL.completed, dispatch, "DateCompleted");
            this.addNcalDateTimeIfNotNull(rDFContainer, NCAL.due, dispatch, "DueDate");
        }

        public URI getType() {
            return NCAL.Todo;
        }
    }

    public static class RootFolder
    extends OutlookResource {
        public static final String ITEMTYPE = "root";

        public RootFolder(OutlookCrawler outlookCrawler) {
            super(outlookCrawler, outlookCrawler.getUriPrefix() + ITEMTYPE, outlookCrawler.getOutlookMapi(), ITEMTYPE);
        }

        protected void addData(RDFContainer rDFContainer) throws IOException {
            rDFContainer.add(NIE.title, "Outlook root folder");
        }

        public long getLastModified() {
            return 0L;
        }

        public URI getType() {
            return NFO.Folder;
        }

        public boolean isFolder() {
            return true;
        }
    }

    public static abstract class OutlookResourceSave
    extends OutlookResource {
        protected Logger logger = LoggerFactory.getLogger(this.getClass());
        protected String saveRedemptionClass = null;
        private Dispatch saveResource = null;

        protected OutlookResourceSave(OutlookCrawler outlookCrawler, Dispatch dispatch, String string) {
            super(outlookCrawler, dispatch, string);
        }

        public OutlookResourceSave(OutlookCrawler outlookCrawler, String string, Dispatch dispatch, String string2) {
            super(outlookCrawler, string, dispatch, string2);
        }

        public Dispatch getSaveResource() {
            if (this.saveResource == null) {
                if (this.getOLCrawler().hasRedemption()) {
                    try {
                        this.saveResource = new ActiveXComponent(this.saveRedemptionClass);
                    }
                    catch (ComFailException comFailException) {
                        this.logger.warn("Redemption error, cannot get redemption object for " + this.saveRedemptionClass);
                        return null;
                    }
                    Dispatch.put((Dispatch)this.saveResource, (String)"Item", (Object)this.getResource());
                } else {
                    return this.getResource();
                }
            }
            return this.saveResource;
        }

        public void release() {
            if (this.saveResource != null) {
                this.saveResource.safeRelease();
            }
            super.release();
        }
    }

    public static class Note
    extends OutlookResource {
        public static final String ITEMTYPE = "note";

        public Note(OutlookCrawler outlookCrawler, Dispatch dispatch) {
            super(outlookCrawler, dispatch, ITEMTYPE);
        }

        protected void addData(RDFContainer rDFContainer) throws IOException {
            Dispatch dispatch = this.getResource();
            this.addPropertyIfNotNull(rDFContainer, NIE.title, dispatch, "Subject");
            this.addPropertyIfNotNull(rDFContainer, NIE.plainTextContent, dispatch, "Body");
        }

        public URI getType() {
            return NFO.TextDocument;
        }
    }

    public static class Mail
    extends OutlookResourceSave {
        public static final String ITEMTYPE = "mail";

        public Mail(OutlookCrawler outlookCrawler, Dispatch dispatch) {
            super(outlookCrawler, dispatch, ITEMTYPE);
            this.saveRedemptionClass = "Redemption.SafeMailItem";
        }

        protected void addData(RDFContainer rDFContainer) throws IOException {
            Dispatch dispatch = this.getSaveResource();
            ValueFactory valueFactory = rDFContainer.getValueFactory();
            this.addPropertyIfNotNull(rDFContainer, NMO.messageSubject, dispatch, "Subject");
            this.addDateIfNotNull(rDFContainer, NMO.receivedDate, dispatch, "ReceivedTime");
            this.addDateIfNotNull(rDFContainer, NMO.sentDate, dispatch, "SentOn");
            this.addPropertyIfNotNull(rDFContainer, NMO.plainTextMessageContent, dispatch, "Body");
            String string = this.getLiteralOf(this.getSaveResource(), "SenderName");
            String string2 = this.getLiteralOf(this.getSaveResource(), "SenderEmailAddress");
            if (string != null || string2 != null) {
                try {
                    URI uRI = valueFactory.createURI(this.getUri() + "_FROM");
                    rDFContainer.add(valueFactory.createStatement((Resource)uRI, RDF.type, (Node)NCO.Contact));
                    if (string != null) {
                        rDFContainer.add(valueFactory.createStatement((Resource)uRI, NCO.fullname, (Node)valueFactory.createLiteral(string)));
                    }
                    if (string2 != null) {
                        Resource resource = UriUtil.generateRandomResource(rDFContainer.getModel());
                        this.addStatement(rDFContainer, (Resource)uRI, NCO.hasEmailAddress, (Node)resource);
                        this.addStatement(rDFContainer, resource, RDF.type, (Node)NCO.EmailAddress);
                        this.addStatement(rDFContainer, resource, NCO.emailAddress, (Node)valueFactory.createLiteral(string2));
                    }
                    rDFContainer.add(NMO.from, (Node)uRI);
                }
                catch (ModelException modelException) {
                    this.logger.error("ModelException while adding statements", (Throwable)modelException);
                }
            }
            this.addRecipientsIfNotNull(rDFContainer, this.getResource(), "Recipients", this);
        }

        public URI getType() {
            return NMO.Email;
        }
    }

    public static class Folder
    extends OutlookResource {
        public static final String ITEMTYPE = "folder";

        public Folder(OutlookCrawler outlookCrawler, Dispatch dispatch) {
            super(outlookCrawler, dispatch, ITEMTYPE);
        }

        public Folder(OutlookCrawler outlookCrawler, Dispatch dispatch, String string) {
            super(outlookCrawler, dispatch, string);
        }

        public Folder(OutlookCrawler outlookCrawler, String string, Dispatch dispatch, String string2) {
            super(outlookCrawler, string, dispatch, string2);
        }

        protected void addData(RDFContainer rDFContainer) throws IOException {
            this.addPropertyIfNotNull(rDFContainer, NIE.title, this.getResource(), "Name");
        }

        public long getLastModified() {
            return new Date().getTime();
        }

        public URI getType() {
            return NFO.Folder;
        }

        public int getDefaultItemType() {
            int n = Dispatch.get((Dispatch)this.getResource(), (String)"DefaultItemType").toInt();
            return n;
        }

        public String getDefaultMessageClass() {
            Variant variant = Dispatch.get((Dispatch)this.getResource(), (String)"DefaultMessageClass");
            return variant.toString();
        }

        public String getName() {
            String string = this.getLiteralOf(this.getResource(), "Name");
            return string;
        }

        public boolean isFolder() {
            return true;
        }
    }

    public static class Document
    extends OutlookResource {
        public static final String ITEMTYPE = "document";

        public Document(OutlookCrawler outlookCrawler, Dispatch dispatch) {
            super(outlookCrawler, dispatch, ITEMTYPE);
        }

        protected void addData(RDFContainer rDFContainer) throws IOException {
            Dispatch dispatch = this.getResource();
            this.addPropertyIfNotNull(rDFContainer, NIE.title, dispatch, "Subject");
            this.addPropertyIfNotNull(rDFContainer, NIE.plainTextContent, dispatch, "Body");
        }

        public URI getType() {
            return NFO.TextDocument;
        }
    }

    public static class DistList
    extends OutlookResourceSave {
        public static final String ITEMTYPE = "distlist";

        public DistList(OutlookCrawler outlookCrawler, Dispatch dispatch) {
            super(outlookCrawler, dispatch, ITEMTYPE);
            this.saveRedemptionClass = "Redemption.SafeDistList";
        }

        protected void addData(RDFContainer rDFContainer) throws IOException {
        }

        public URI getType() {
            return NCO.ContactGroup;
        }
    }

    public static class Contact
    extends OutlookResourceSave {
        public static final String ITEMTYPE = "contact";

        public Contact(OutlookCrawler outlookCrawler, Dispatch dispatch) {
            super(outlookCrawler, dispatch, ITEMTYPE);
            this.saveRedemptionClass = "Redemption.SafeContactItem";
        }

        protected void addData(RDFContainer rDFContainer) throws IOException {
            Dispatch dispatch = this.getSaveResource();
            this.addPropertyIfNotNull(rDFContainer, NIE.title, dispatch, "Subject");
            Model model = rDFContainer.getModel();
            URI uRI = rDFContainer.getDescribedUri();
            this.addEmailAddressIfNotNull(model, (Resource)uRI, dispatch, "Email1Address");
            this.addEmailAddressIfNotNull(model, (Resource)uRI, dispatch, "Email2Address");
            this.addEmailAddressIfNotNull(model, (Resource)uRI, dispatch, "Email3Address");
            this.addPropertyIfNotNull(rDFContainer, NCO.websiteUrl, dispatch, "WebPage");
            this.addPropertyIfNotNull(rDFContainer, NCO.nameFamily, dispatch, "LastName");
            this.addPropertyIfNotNull(rDFContainer, NCO.nameGiven, dispatch, "FirstName");
            this.addPropertyIfNotNull(rDFContainer, NCO.nameAdditional, dispatch, "Title");
            this.addPropertyIfNotNull(rDFContainer, NCO.fullname, dispatch, "Fullname");
            this.addPropertyIfNotNull(rDFContainer, NCO.title, dispatch, "Title");
            this.addPropertyIfNotNull(rDFContainer, NCO.note, this.getSaveResource(), "Body");
            this.addTelephoneNumberIfNotNull(model, (Resource)uRI, dispatch, "BusinessTelephoneNumber", "work", NCO.PhoneNumber);
            this.addTelephoneNumberIfNotNull(model, (Resource)uRI, dispatch, "HomeTelephoneNumber", "home", NCO.PhoneNumber);
            this.addTelephoneNumberIfNotNull(model, (Resource)uRI, dispatch, "MobileTelephoneNumber", "cell", NCO.CellPhoneNumber);
            this.readAddress(dispatch, "BusinessAddress", rDFContainer, "work");
            this.readAddress(dispatch, "HomeAddress", rDFContainer, "home");
            this.readAddress(dispatch, "MailingAddress", rDFContainer, "mailing");
            this.readAddress(dispatch, "OtherAddress", rDFContainer, "other");
            String string = this.getLiteralOf(dispatch, "Companies");
            String string2 = this.getLiteralOf(dispatch, "CompanyName");
            String string3 = this.getLiteralOf(dispatch, "JobTitle");
            if (string2 != null || string3 != null || string != null) {
                try {
                    URI uRI2 = rDFContainer.getValueFactory().createURI(this.getUri() + "_" + "Affiliation");
                    this.addStatement(rDFContainer, (Resource)uRI, NCO.hasAffiliation, (Node)uRI2);
                    this.addStatement(rDFContainer, (Resource)uRI2, RDF.type, (Node)NCO.Affiliation);
                    if (string3 != null) {
                        this.addStatement(rDFContainer, (Resource)uRI2, NCO.title, string3);
                    }
                    if (string2 != null || string != null) {
                        URI uRI3 = rDFContainer.getValueFactory().createURI(this.getUri() + "_" + "Organization");
                        this.addStatement(rDFContainer, (Resource)uRI2, NCO.org, (Node)uRI3);
                        this.addStatement(rDFContainer, (Resource)uRI3, RDF.type, (Node)NCO.OrganizationContact);
                        if (string != null) {
                            this.addStatement(rDFContainer, (Resource)uRI3, NCO.fullname, string);
                        }
                        if (string2 != null) {
                            this.addStatement(rDFContainer, (Resource)uRI3, NCO.fullname, string2);
                        }
                    }
                }
                catch (ModelException modelException) {
                    throw new ModelRuntimeException((Throwable)modelException);
                }
            }
        }

        public URI getType() {
            return NCO.Contact;
        }

        public void readAddress(Dispatch dispatch, String string, RDFContainer rDFContainer, String string2) {
            String string3;
            Variant variant = Dispatch.get((Dispatch)dispatch, (String)(string + "City"));
            ValueFactory valueFactory = rDFContainer.getValueFactory();
            String string4 = variant == null ? null : variant.getString();
            variant = Dispatch.get((Dispatch)dispatch, (String)(string + "Country"));
            String string5 = variant == null ? null : variant.getString();
            variant = Dispatch.get((Dispatch)dispatch, (String)(string + "PostOfficeBox"));
            String string6 = variant == null ? null : variant.getString();
            variant = Dispatch.get((Dispatch)dispatch, (String)(string + "PostalCode"));
            String string7 = variant == null ? null : variant.getString();
            variant = Dispatch.get((Dispatch)dispatch, (String)(string + "State"));
            String string8 = variant == null ? null : variant.getString();
            variant = Dispatch.get((Dispatch)dispatch, (String)(string + "Street"));
            String string9 = string3 = variant == null ? null : variant.getString();
            if (string4 != null && string4.length() == 0) {
                string4 = null;
            }
            if (string5 != null && string5.length() == 0) {
                string5 = null;
            }
            if (string6 != null && string6.length() == 0) {
                string6 = null;
            }
            if (string7 != null && string7.length() == 0) {
                string7 = null;
            }
            if (string8 != null && string8.length() == 0) {
                string8 = null;
            }
            if (string3 != null && string3.length() == 0) {
                string3 = null;
            }
            if (string4 != null || string5 != null || string6 != null || string7 != null || string8 != null || string3 != null) {
                try {
                    URI uRI = rDFContainer.getValueFactory().createURI(this.getUri() + "_" + string);
                    rDFContainer.add(valueFactory.createStatement((Resource)uRI, RDF.type, (Node)NCO.PostalAddress));
                    if (string4 != null) {
                        rDFContainer.add(valueFactory.createStatement((Resource)uRI, NCO.locality, (Node)valueFactory.createLiteral(string4)));
                    }
                    if (string5 != null) {
                        rDFContainer.add(valueFactory.createStatement((Resource)uRI, NCO.country, (Node)valueFactory.createLiteral(string5)));
                    }
                    if (string6 != null) {
                        rDFContainer.add(valueFactory.createStatement((Resource)uRI, NCO.pobox, (Node)valueFactory.createLiteral(string6)));
                    }
                    if (string7 != null) {
                        rDFContainer.add(valueFactory.createStatement((Resource)uRI, NCO.postalcode, (Node)valueFactory.createLiteral(string7)));
                    }
                    if (string8 != null) {
                        rDFContainer.add(valueFactory.createStatement((Resource)uRI, NCO.region, (Node)valueFactory.createLiteral(string8)));
                    }
                    if (string3 != null) {
                        rDFContainer.add(valueFactory.createStatement((Resource)uRI, NCO.streetAddress, (Node)valueFactory.createLiteral(string3)));
                    }
                    if (string2 != null) {
                        this.addStatement(rDFContainer, (Resource)uRI, NCO.contactMediumComment, string2);
                    }
                    rDFContainer.add(NCO.hasPostalAddress, (Node)uRI);
                }
                catch (ModelException modelException) {
                    this.logger.error("ModelException while adding statements", (Throwable)modelException);
                }
            }
        }
    }

    public static class Calendar
    extends Folder {
        public static final String ITEMTYPE = "calendar";

        public Calendar(OutlookCrawler outlookCrawler, Dispatch dispatch) {
            super(outlookCrawler, dispatch, ITEMTYPE);
        }
    }

    public static class Appointment
    extends OutlookResourceSave {
        public static String ITEMTYPE = "appointment";

        public Appointment(OutlookCrawler outlookCrawler, Dispatch dispatch) {
            super(outlookCrawler, dispatch, ITEMTYPE);
            this.saveRedemptionClass = "Redemption.SafeAppointmentItem";
        }

        protected void addData(RDFContainer rDFContainer) throws IOException {
            String string;
            Dispatch dispatch = this.getSaveResource();
            this.addPropertyIfNotNull(rDFContainer, NIE.title, dispatch, "Subject");
            this.addPropertyIfNotNull(rDFContainer, NIE.plainTextContent, dispatch, "Body");
            this.addPropertyIfNotNull(rDFContainer, NIE.identifier, dispatch, "EntryID");
            this.addDateIfNotNull(rDFContainer, NCAL.dtstamp, dispatch, "CreationTime");
            this.addDateIfNotNull(rDFContainer, NCAL.lastModified, dispatch, "LastModificationTime");
            this.addNcalDateTimeIfNotNull(rDFContainer, NCAL.dtstart, dispatch, "Start");
            this.addNcalDateTimeIfNotNull(rDFContainer, NCAL.dtend, dispatch, "End");
            this.addPropertyIfNotNull(rDFContainer, NCAL.location, dispatch, "Location");
            String string2 = this.getLiteralOf(dispatch, "Organizer");
            if (string2 != null) {
                string = rDFContainer.getModel().createURI(rDFContainer.getDescribedUri() + "-organizer");
                rDFContainer.add(NCAL.organizer, (Node)string);
                rDFContainer.getModel().addStatement((Resource)string, RDF.type, (Node)NCAL.Organizer);
                rDFContainer.getModel().addStatement((Resource)string, NCO.fullname, string2);
            }
            string = this.getLiteralOf(dispatch, "OptionalAttendees");
            this.logger.debug("optional: " + string);
            this.addRecipientsIfNotNull(rDFContainer, this.getResource(), "Recipients", this);
        }

        public URI getType() {
            return NCAL.Event;
        }
    }
}

