/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.websites;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.List;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.datasource.config.ConfigurationUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.UpdateException;
import org.semanticdesktop.aperture.vocabulary.NAO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.semanticdesktop.aperture.websites.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTagCrawler
extends CrawlerBase {
    Logger log = LoggerFactory.getLogger(AbstractTagCrawler.class);

    @Override
    protected ExitCode crawlObjects() {
        DataSource dataSource = this.getDataSource();
        RDFContainer rDFContainer = dataSource.getConfiguration();
        String string = ConfigurationUtil.getUsername(rDFContainer);
        String string2 = ConfigurationUtil.getPassword(rDFContainer);
        try {
            List<String> list = this.crawlTags(string, string2);
            for (String string3 : list) {
                URIImpl uRIImpl = new URIImpl(string3);
                if (this.accessData.isKnownId(string3)) {
                    this.reportUnmodifiedDataObject(string3);
                    continue;
                }
                this.accessData.put(string3, "date", Long.toString(new Date().getTime()));
                RDFContainer rDFContainer2 = this.getRDFContainerFactory(string3).getRDFContainer((URI)uRIImpl);
                DataObjectBase dataObjectBase = new DataObjectBase((URI)uRIImpl, dataSource, rDFContainer2);
                rDFContainer2.add(RDF.type, (Node)NAO.Tag);
                rDFContainer2.add(NIE.rootElementOf, (Node)this.getDataSource().getID());
                rDFContainer2.add(RDFS.label, URLDecoder.decode(this.getShortName(uRIImpl.toString()), "utf-8"));
                this.reportNewDataObject(dataObjectBase);
            }
            this.crawlTheRest(string, string2);
        }
        catch (Exception exception) {
            this.log.info("Could not crawl tag-datasource.", (Throwable)exception);
            return ExitCode.FATAL_ERROR;
        }
        return this.stopRequested ? ExitCode.STOP_REQUESTED : ExitCode.COMPLETED;
    }

    protected void crawlTheRest(String string, String string2) throws Exception {
    }

    protected void reportItem(Tag tag, List<String> list) throws UpdateException, UnsupportedEncodingException {
        String string = tag.getUri();
        if (this.accessData.isKnownId(string)) {
            this.reportUnmodifiedDataObject(string);
        } else {
            this.accessData.put(string, "date", Long.toString(new Date().getTime()));
            URIImpl uRIImpl = new URIImpl(string);
            RDFContainer rDFContainer = this.getRDFContainerFactory(string).getRDFContainer((URI)uRIImpl);
            DataObjectBase dataObjectBase = new DataObjectBase((URI)uRIImpl, this.source, rDFContainer);
            rDFContainer.add(RDF.type, (Node)NAO.Tag);
            rDFContainer.add(RDFS.label, URLDecoder.decode(tag.getName(), "utf-8"));
            for (String string2 : list) {
                rDFContainer.add(NAO.hasTag, (Node)new URIImpl(string2));
            }
            this.reportNewDataObject(dataObjectBase);
        }
    }

    protected abstract List<String> crawlTags(String var1, String var2) throws Exception;

    private String getShortName(String string) {
        if (string.indexOf(35) > 0) {
            string = string.substring(string.lastIndexOf(35) + 1);
        } else if (string.indexOf(47) > 0) {
            string = string.substring(string.lastIndexOf(47) + 1);
        }
        return string;
    }
}

