/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.marshall.AdvancedExternalizer;
import org.infinispan.schematic.SchemaLibrary;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Changes;
import org.infinispan.schematic.document.Code;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableArray;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Editor;
import org.infinispan.schematic.document.MaxKey;
import org.infinispan.schematic.document.MinKey;
import org.infinispan.schematic.document.Null;
import org.infinispan.schematic.document.ObjectId;
import org.infinispan.schematic.document.Symbol;
import org.infinispan.schematic.document.Timestamp;
import org.infinispan.schematic.internal.CacheSchematicDb;
import org.infinispan.schematic.internal.InMemorySchemaLibrary;
import org.infinispan.schematic.internal.SchematicEntryLiteral;
import org.infinispan.schematic.internal.delta.AddValueIfAbsentOperation;
import org.infinispan.schematic.internal.delta.AddValueOperation;
import org.infinispan.schematic.internal.delta.ClearOperation;
import org.infinispan.schematic.internal.delta.DocumentObserver;
import org.infinispan.schematic.internal.delta.Operation;
import org.infinispan.schematic.internal.delta.PutOperation;
import org.infinispan.schematic.internal.delta.RemoveAllValuesOperation;
import org.infinispan.schematic.internal.delta.RemoveAtIndexOperation;
import org.infinispan.schematic.internal.delta.RemoveOperation;
import org.infinispan.schematic.internal.delta.RemoveValueOperation;
import org.infinispan.schematic.internal.delta.RetainAllValuesOperation;
import org.infinispan.schematic.internal.delta.SetValueOperation;
import org.infinispan.schematic.internal.document.ArrayEditor;
import org.infinispan.schematic.internal.document.BasicArray;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.infinispan.schematic.internal.document.DefaultDocumentValueFactory;
import org.infinispan.schematic.internal.document.DocumentEditor;
import org.infinispan.schematic.internal.document.DocumentExternalizer;
import org.infinispan.schematic.internal.document.DocumentValueFactory;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.schematic.internal.document.ObservableDocumentEditor;
import org.infinispan.schematic.internal.document.Paths;
import org.infinispan.util.Util;

public class Schematic {
    protected static DocumentValueFactory DEFAULT_FACTORY = DefaultDocumentValueFactory.INSTANCE;
    private static final Set<AdvancedExternalizer<?>> EXTERNALIZERS;

    public static SchematicDb get(CacheContainer cacheContainer, String cacheName) {
        Cache cache = cacheContainer.getCache(cacheName);
        return new CacheSchematicDb((Cache<String, SchematicEntry>)cache);
    }

    public static EditableDocument newDocument(Document original) {
        BasicDocument newDoc = new BasicDocument();
        newDoc.putAll(original);
        return new DocumentEditor(newDoc, DEFAULT_FACTORY);
    }

    public static EditableDocument newDocument() {
        return new DocumentEditor(new BasicDocument(), DEFAULT_FACTORY);
    }

    public static EditableDocument newDocument(String name, Object value) {
        return new DocumentEditor(new BasicDocument(name, value), DEFAULT_FACTORY);
    }

    public static EditableDocument newDocument(String name1, Object value1, String name2, Object value2) {
        return new DocumentEditor(new BasicDocument(name1, value1, name2, value2), DEFAULT_FACTORY);
    }

    public static EditableDocument newDocument(String name1, Object value1, String name2, Object value2, String name3, Object value3) {
        return new DocumentEditor(new BasicDocument(name1, value1, name2, value2, name3, value3), DEFAULT_FACTORY);
    }

    public static EditableDocument newDocument(String name1, Object value1, String name2, Object value2, String name3, Object value3, String name4, Object value4) {
        return new DocumentEditor(new BasicDocument(name1, value1, name2, value2, name3, value3, name4, value4), DEFAULT_FACTORY);
    }

    public static EditableArray newArray() {
        return new ArrayEditor(new BasicArray(), DEFAULT_FACTORY);
    }

    public static EditableArray newArray(int initialCapacity) {
        return new ArrayEditor(new BasicArray(initialCapacity), DEFAULT_FACTORY);
    }

    public static EditableArray newArray(Collection<?> values) {
        BasicArray array = new BasicArray(values.size());
        array.addAllValues(values);
        return new ArrayEditor(array, DEFAULT_FACTORY);
    }

    public static EditableArray newArray(Object ... values) {
        BasicArray array = new BasicArray();
        for (Object value : values) {
            array.addValue(value);
        }
        return new ArrayEditor(array, DEFAULT_FACTORY);
    }

    public static Editor editDocument(Document document, boolean clone) {
        if (clone) {
            document = document.clone();
        }
        final LinkedList<Operation> operations = new LinkedList<Operation>();
        DocumentObserver observer = new DocumentObserver(){

            @Override
            public void addOperation(Operation o) {
                if (o != null) {
                    operations.add(o);
                }
            }
        };
        MutableDocument mutable = null;
        if (document instanceof MutableDocument) {
            mutable = (MutableDocument)document;
        } else if (document instanceof DocumentEditor) {
            mutable = ((DocumentEditor)document).asMutableDocument();
        }
        return new EditorImpl(mutable, observer, operations);
    }

    public static SchemaLibrary createSchemaLibrary() {
        return new InMemorySchemaLibrary("In-memory schema library");
    }

    public static SchemaLibrary createSchemaLibrary(String name) {
        return new InMemorySchemaLibrary(name != null ? name : "In-memory schema library");
    }

    public static AdvancedExternalizer<Object>[] externalizers() {
        return EXTERNALIZERS.toArray(new AdvancedExternalizer[EXTERNALIZERS.size()]);
    }

    public static Set<AdvancedExternalizer<?>> externalizerSet() {
        return EXTERNALIZERS;
    }

    static {
        HashSet<AbstractExternalizer> externalizers = new HashSet<AbstractExternalizer>();
        externalizers.add(new SchematicEntryLiteral.Externalizer());
        externalizers.add(new DocumentExternalizer());
        externalizers.add(new Binary.Externalizer());
        externalizers.add(new Code.Externalizer());
        externalizers.add(new MaxKey.Externalizer());
        externalizers.add(new MinKey.Externalizer());
        externalizers.add(new Null.Externalizer());
        externalizers.add(new ObjectId.Externalizer());
        externalizers.add(new Symbol.Externalizer());
        externalizers.add(new Timestamp.Externalizer());
        externalizers.add(new Paths.Externalizer());
        externalizers.add(new AddValueIfAbsentOperation.Externalizer());
        externalizers.add(new AddValueOperation.Externalizer());
        externalizers.add(new ClearOperation.Externalizer());
        externalizers.add(new PutOperation.Externalizer());
        externalizers.add(new RemoveAllValuesOperation.Externalizer());
        externalizers.add(new RemoveAtIndexOperation.Externalizer());
        externalizers.add(new RemoveOperation.Externalizer());
        externalizers.add(new RemoveValueOperation.Externalizer());
        externalizers.add(new RetainAllValuesOperation.Externalizer());
        externalizers.add(new SetValueOperation.Externalizer());
        EXTERNALIZERS = Collections.unmodifiableSet(externalizers);
    }

    protected static class DocumentChanges
    implements Changes,
    Iterable<Operation> {
        private final List<Operation> operations;

        protected DocumentChanges(List<Operation> operations) {
            this.operations = operations;
        }

        @Override
        public Iterator<Operation> iterator() {
            return this.operations.iterator();
        }

        @Override
        public boolean isEmpty() {
            return this.operations.isEmpty();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator<Operation> iter = this.operations.iterator();
            if (iter.hasNext()) {
                sb.append(iter.next());
                while (iter.hasNext()) {
                    sb.append("\n").append(iter.next());
                }
            }
            return sb.toString();
        }

        public static class Externalizer
        extends AbstractExternalizer<DocumentChanges> {
            private static final long serialVersionUID = 1L;

            public void writeObject(ObjectOutput output, DocumentChanges changes) throws IOException {
                output.writeObject(changes.operations);
            }

            public DocumentChanges readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                List operations = (List)input.readObject();
                return new DocumentChanges(operations);
            }

            public Integer getId() {
                return 1623;
            }

            public Set<Class<? extends DocumentChanges>> getTypeClasses() {
                return Util.asSet((Object[])new Class[]{DocumentChanges.class});
            }
        }
    }

    protected static class EditorImpl
    extends ObservableDocumentEditor
    implements Editor {
        private static final long serialVersionUID = 1L;
        private final List<Operation> operations;

        public EditorImpl(MutableDocument document, DocumentObserver observer, List<Operation> operations) {
            super(document, Paths.rootPath(), observer, null);
            this.operations = operations;
        }

        @Override
        public Changes getChanges() {
            return new DocumentChanges(this.operations);
        }

        @Override
        public void apply(Changes changes) {
            this.apply(changes, null);
        }

        private static final Array.Entry newEntry(int index, Object value) {
            return new BasicArray.BasicEntry(index, value);
        }

        @Override
        public void apply(Changes changes, Editor.Observer observer) {
            if (changes.isEmpty()) {
                return;
            }
            MutableDocument mutable = this.asMutableDocument();
            for (Operation operation : (DocumentChanges)changes) {
                Operation op;
                operation.replay(mutable);
                if (observer == null) continue;
                if (operation instanceof SetValueOperation) {
                    op = (SetValueOperation)operation;
                    observer.setArrayValue(op.getParentPath(), EditorImpl.newEntry(((SetValueOperation)op).getIndex(), ((SetValueOperation)op).getValue()));
                    continue;
                }
                if (operation instanceof AddValueOperation) {
                    op = (AddValueOperation)operation;
                    if (((AddValueOperation)op).getActualIndex() == -1) continue;
                    observer.addArrayValue(op.getParentPath(), EditorImpl.newEntry(((AddValueOperation)op).getActualIndex(), ((AddValueOperation)op).getValue()));
                    continue;
                }
                if (operation instanceof AddValueIfAbsentOperation) {
                    op = (AddValueIfAbsentOperation)operation;
                    if (!((AddValueIfAbsentOperation)op).isAdded()) continue;
                    observer.addArrayValue(op.getParentPath(), EditorImpl.newEntry(((AddValueOperation)op).getIndex(), ((AddValueOperation)op).getValue()));
                    continue;
                }
                if (operation instanceof RemoveValueOperation) {
                    op = (RemoveValueOperation)operation;
                    if (((RemoveValueOperation)op).getActualIndex() == -1) continue;
                    observer.removeArrayValue(op.getParentPath(), EditorImpl.newEntry(((RemoveValueOperation)op).getActualIndex(), ((RemoveValueOperation)op).getRemovedValue()));
                    continue;
                }
                if (operation instanceof RemoveAtIndexOperation) {
                    op = (RemoveAtIndexOperation)operation;
                    observer.removeArrayValue(op.getParentPath(), EditorImpl.newEntry(((RemoveAtIndexOperation)op).getIndex(), ((RemoveAtIndexOperation)op).getRemovedValue()));
                    continue;
                }
                if (operation instanceof RetainAllValuesOperation) {
                    op = (RetainAllValuesOperation)operation;
                    for (Array.Entry entry : ((RetainAllValuesOperation)op).getRemovedEntries()) {
                        observer.removeArrayValue(op.getParentPath(), entry);
                    }
                    continue;
                }
                if (operation instanceof RemoveAllValuesOperation) {
                    op = (RemoveAllValuesOperation)operation;
                    for (Array.Entry entry : ((RemoveAllValuesOperation)op).getRemovedEntries()) {
                        observer.removeArrayValue(op.getParentPath(), entry);
                    }
                    continue;
                }
                if (operation instanceof ClearOperation) {
                    op = (ClearOperation)operation;
                    observer.clear(op.getParentPath());
                    continue;
                }
                if (operation instanceof PutOperation) {
                    op = (PutOperation)operation;
                    observer.put(op.getParentPath(), ((PutOperation)op).getFieldName(), ((PutOperation)op).getNewValue());
                    continue;
                }
                if (!(operation instanceof RemoveOperation) || !((RemoveOperation)(op = (RemoveOperation)operation)).isRemoved()) continue;
                observer.remove(op.getParentPath(), ((RemoveOperation)op).getFieldName());
            }
        }
    }

    public static interface ContentTypes {
        public static final String BINARY = "application/octet-stream";
        public static final String JSON = "application/json";
        public static final String BSON = "application/bson";
        public static final String JSON_SCHEMA = "application/schema+json";
    }
}

