/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.infinispan.schematic.DocumentLibrary;
import org.infinispan.schematic.document.Document;
import org.infinispan.util.concurrent.FutureListener;
import org.infinispan.util.concurrent.NotifyingFuture;

public class InMemoryDocumentLibrary
implements DocumentLibrary,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final ConcurrentMap<String, Document> documents = new ConcurrentHashMap<String, Document>();

    public InMemoryDocumentLibrary(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Document get(String key) {
        return (Document)this.documents.get(key);
    }

    @Override
    public Document put(String key, Document document) {
        return this.documents.put(key, document);
    }

    @Override
    public Document putIfAbsent(String key, Document document) {
        return this.documents.putIfAbsent(key, document);
    }

    @Override
    public Document replace(String key, Document document) {
        return this.documents.replace(key, document);
    }

    @Override
    public Document remove(String key) {
        return (Document)this.documents.remove(key);
    }

    @Override
    public NotifyingFuture<Document> getAsync(String key) {
        return new ImmediateFuture(this.get(key));
    }

    @Override
    public NotifyingFuture<Document> putAsync(String key, Document document) {
        return new ImmediateFuture(this.put(key, document));
    }

    @Override
    public NotifyingFuture<Document> putIfAbsentAsync(String key, Document document) {
        return new ImmediateFuture(this.putIfAbsent(key, document));
    }

    @Override
    public NotifyingFuture<Document> replaceAsync(String key, Document document) {
        return new ImmediateFuture(this.replace(key, document));
    }

    @Override
    public NotifyingFuture<Document> removeAsync(String key) {
        return new ImmediateFuture(this.remove(key));
    }

    protected static class ImmediateFuture
    implements NotifyingFuture<Document> {
        private final Document value;

        protected ImmediateFuture(Document value) {
            this.value = value;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return true;
        }

        public Document get() {
            return this.value;
        }

        public Document get(long timeout, TimeUnit unit) {
            return this.value;
        }

        public NotifyingFuture<Document> attachListener(FutureListener<Document> listener) {
            throw new UnsupportedOperationException();
        }
    }
}

