/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.batch.BatchContainer;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.SchematicEntryDelta;
import org.infinispan.schematic.internal.SchematicEntryProxy;
import org.infinispan.schematic.internal.delta.NullDelta;
import org.infinispan.schematic.internal.delta.PutOperation;
import org.infinispan.schematic.internal.delta.RemoveOperation;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.infinispan.schematic.internal.document.DocumentEditor;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.schematic.internal.document.ObservableDocumentEditor;
import org.infinispan.schematic.internal.document.Paths;
import org.infinispan.util.Util;

public class SchematicEntryLiteral
implements SchematicEntry,
DeltaAware {
    private MutableDocument value;
    private SchematicEntryDelta delta = null;
    private volatile SchematicEntryProxy proxy;
    volatile boolean copied = false;
    volatile boolean removed = false;

    public static SchematicEntry newInstance(Cache<String, SchematicEntry> cache, String key) {
        SchematicEntry value = new SchematicEntryLiteral(key);
        SchematicEntry oldValue = (SchematicEntry)cache.putIfAbsent((Object)key, (Object)value);
        if (oldValue != null) {
            value = oldValue;
        }
        return value;
    }

    public SchematicEntryLiteral() {
        BasicDocument metadata = new BasicDocument();
        this.value = new BasicDocument("metadata", metadata);
    }

    public SchematicEntryLiteral(String key) {
        BasicDocument metadata = new BasicDocument("id", key);
        this.value = new BasicDocument("metadata", metadata);
    }

    public SchematicEntryLiteral(String key, boolean isCopy) {
        this(key);
        this.copied = true;
    }

    protected SchematicEntryLiteral(MutableDocument document) {
        this.value = document;
    }

    public SchematicEntryLiteral copyForWrite() {
        try {
            SchematicEntryLiteral clone = (SchematicEntryLiteral)super.clone();
            clone.proxy = this.proxy;
            clone.copied = true;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected final MutableDocument data() {
        return this.value;
    }

    public String toString() {
        return "SchematicValueImpl" + this.value;
    }

    public void initForWriting() {
        this.delta = new SchematicEntryDelta();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchematicEntry getProxy(Cache<String, SchematicEntry> cache, String mapKey, BatchContainer batchContainer, InvocationContextContainer icc) {
        if (this.proxy == null) {
            SchematicEntryLiteral schematicEntryLiteral = this;
            synchronized (schematicEntryLiteral) {
                if (this.proxy == null) {
                    this.proxy = new SchematicEntryProxy(cache, mapKey, batchContainer, icc);
                }
            }
        }
        return this.proxy;
    }

    public void markRemoved(boolean b) {
        this.removed = b;
    }

    public Delta delta() {
        Delta toReturn = this.delta == null ? NullDelta.INSTANCE : this.delta;
        this.delta = null;
        return toReturn;
    }

    protected SchematicEntryDelta getDelta() {
        if (this.delta == null) {
            this.delta = new SchematicEntryDelta();
        }
        return this.delta;
    }

    public void commit() {
        this.copied = false;
        this.delta = null;
    }

    @Override
    public Document getMetadata() {
        return this.value.getDocument("metadata");
    }

    protected MutableDocument mutableMetadata() {
        return (MutableDocument)this.getMetadata();
    }

    @Override
    public String getContentType() {
        return this.getMetadata().getString("contentType");
    }

    @Override
    public Object getContent() {
        return this.value.getDocument("content");
    }

    @Override
    public Document getContentAsDocument() {
        return this.value.getDocument("content");
    }

    @Override
    public Binary getContentAsBinary() {
        return this.value.getBinary("content");
    }

    @Override
    public boolean hasDocumentContent() {
        return this.getContentAsDocument() != null;
    }

    @Override
    public boolean hasBinaryContent() {
        return this.getContentAsBinary() != null;
    }

    protected Object setContent(Object content) {
        assert (content != null);
        Object existing = this.value.put("content", content);
        if (existing != null) {
            this.getDelta().addOperation(new PutOperation(FieldPath.ROOT, "content", existing, content));
        } else {
            this.getDelta().addOperation(new RemoveOperation(FieldPath.ROOT, "content", content));
        }
        return existing;
    }

    protected void setMetadata(Document metadata, String defaultContentType) {
        if (metadata != null) {
            if (metadata instanceof EditableDocument) {
                metadata = ((EditableDocument)metadata).unwrap();
            }
            Document existingMetadata = this.getMetadata();
            BasicDocument newMetadata = new BasicDocument(metadata.size() + 1);
            newMetadata.put("id", existingMetadata.get("id"));
            for (Document.Field field : metadata.fields()) {
                String fieldName = field.getName();
                if (fieldName.equals("id")) continue;
                newMetadata.put(fieldName, field.getValue());
            }
            if (newMetadata.getString("contentType") == null) {
                newMetadata.put("contentType", defaultContentType);
            }
            this.value.put("metadata", newMetadata);
            PutOperation op = new PutOperation(FieldPath.ROOT, "metadata", existingMetadata, newMetadata);
            this.getDelta().addOperation(op);
        }
    }

    @Override
    public void setContent(Document content, Document metadata, String defaultContentType) {
        if (content instanceof EditableDocument) {
            content = ((EditableDocument)content).unwrap();
        }
        this.setContent(content);
        this.setMetadata(metadata, defaultContentType);
    }

    @Override
    public void setContent(Binary content, Document metadata, String defaultContentType) {
        this.setContent(content);
        this.setMetadata(metadata, defaultContentType);
    }

    @Override
    public EditableDocument editDocumentContent() {
        Document doc = this.getContentAsDocument();
        if (doc instanceof MutableDocument) {
            MutableDocument mutable = (MutableDocument)doc;
            return new ObservableDocumentEditor(mutable, FieldPath.CONTENT, this.getDelta(), null);
        }
        if (doc instanceof DocumentEditor) {
            return (DocumentEditor)doc;
        }
        return null;
    }

    @Override
    public EditableDocument editMetadata() {
        return new ObservableDocumentEditor(this.mutableMetadata(), FieldPath.METADATA, this.getDelta(), null);
    }

    public static class Externalizer
    extends AbstractExternalizer<SchematicEntryLiteral> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, SchematicEntryLiteral literal) throws IOException {
            output.writeObject(literal.data());
        }

        public SchematicEntryLiteral readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            MutableDocument doc = (MutableDocument)input.readObject();
            return new SchematicEntryLiteral(doc);
        }

        public Integer getId() {
            return 1600;
        }

        public Set<Class<? extends SchematicEntryLiteral>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{SchematicEntryLiteral.class});
        }
    }

    protected static class FieldPath {
        protected static final Path ROOT = Paths.path(new String[0]);
        protected static final Path METADATA = Paths.path("metadata");
        protected static final Path CONTENT = Paths.path("content");
        protected static final Path ID = Paths.path("metadata", "id");
        protected static final Path CONTENT_TYPE = Paths.path("metadata", "contentType");

        protected FieldPath() {
        }
    }
}

