/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.Element;
import org.modeshape.jboss.JBossLifeCycleListener;
import org.modeshape.jboss.ModeShapeServiceNames;
import org.modeshape.jboss.service.EngineService;
import org.modeshape.jboss.subsystem.JBossManagedI18n;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

class ModeShapeAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    private static Element[] attributes = new Element[0];
    final JBossLifeCycleListener shutdownListener = new JBossLifeCycleListener();

    ModeShapeAdd() {
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle bundle = JBossManagedI18n.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("modeshape.add"));
        ModeShapeAdd.describeModeShape(node, "request-properties", bundle);
        return node;
    }

    static void describeModeShape(ModelNode node, String type, ResourceBundle bundle) {
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i].describe(node, type, bundle);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ModeShapeAdd.populate(operation, model);
    }

    static void populate(ModelNode operation, ModelNode model) {
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i].populate(operation, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)Module.getCallerModule().getClassLoader());
            this.initializeModeShapeEngine(context, operation, newControllers);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classloader);
        }
    }

    private void initializeModeShapeEngine(OperationContext context, ModelNode operation, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceTarget target = context.getServiceTarget();
        JBossLifeCycleListener shutdownListener = new JBossLifeCycleListener();
        EngineService engine = this.buildModeShapeEngine(operation);
        ServiceBuilder engineBuilder = target.addService(ModeShapeServiceNames.ENGINE, (Service)engine);
        engineBuilder.addDependency(ModeShapeServiceNames.REPOSITORY, JcrRepository.class, engine.getJcrRepositoryInjector());
        engineBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController controller = engineBuilder.install();
        newControllers.add(controller);
        ServiceContainer container = controller.getServiceContainer();
        container.addTerminateListener((ServiceContainer.TerminateListener)shutdownListener);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private EngineService buildModeShapeEngine(ModelNode node) {
        EngineService engine = new EngineService(new JcrEngine());
        return engine;
    }
}

