/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.modeshape.jboss.Element;
import org.modeshape.jboss.Namespace;

class ModeShapeSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    ModeShapeSubsystemParser() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode node = context.getModelNode();
        if (!node.isDefined()) {
            return;
        }
        if (this.has(node, Element.REPOSITORY_ELEMENT.getLocalName())) {
            ArrayList repositories = new ArrayList(node.get(Element.REPOSITORY_ELEMENT.getLocalName()).keys());
            Collections.sort(repositories);
            if (!repositories.isEmpty()) {
                for (String repository : repositories) {
                    writer.writeStartElement(Element.REPOSITORY_ELEMENT.getLocalName());
                    this.writeRepositoryConfiguration(writer, node.get(new String[]{Element.REPOSITORY_ELEMENT.getLocalName(), repository}), repository);
                    writer.writeEndElement();
                }
            }
        }
        writer.writeEndElement();
    }

    private void writeRepositoryConfiguration(XMLExtendedStreamWriter writer, ModelNode node, String repositoryName) throws XMLStreamException {
        writer.writeAttribute(Element.REPOSITORY_NAME_ATTRIBUTE.getLocalName(), repositoryName);
        this.writeAttribute(writer, Element.REPOSITORY_JNDI_NAME_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.REPOSITORY_ROOT_NODE_ID_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.REPOSITORY_LARGE_VALUE_SIZE_ID_ATTRIBUTE, node);
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "modeshape");
        address.protect();
        ModelNode bootServices = new ModelNode();
        bootServices.get("operation").set("add");
        bootServices.get("address").set(address);
        list.add(bootServices);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (!reader.isStartElement()) continue;
            block0 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MODESHAPE_3_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case REPOSITORY_ELEMENT: {
                            ModelNode repository = new ModelNode();
                            String name = this.parseRepository(reader, repository);
                            if (name != null) {
                                ModelNode repositoryName = address.clone();
                                repositoryName.add("repository", name);
                                repositoryName.protect();
                                repository.get("operation").set("add");
                                repository.get("address").set(repositoryName);
                                list.add(repository);
                                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                                break block0;
                            }
                            throw new XMLStreamException();
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
    }

    void readRepositoryType(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
    }

    private String parseRepository(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        String repositoryName = null;
        if (reader.getAttributeCount() > 0) {
            block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName);
                switch (element) {
                    case REPOSITORY_NAME_ATTRIBUTE: {
                        repositoryName = attrValue;
                        continue block6;
                    }
                    case REPOSITORY_JNDI_NAME_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    case REPOSITORY_ROOT_NODE_ID_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    case REPOSITORY_LARGE_VALUE_SIZE_ID_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        return repositoryName;
    }

    private boolean has(ModelNode node, String name) {
        return node.has(name) && node.get(name).isDefined();
    }

    private void writeElement(XMLExtendedStreamWriter writer, Element element, ModelNode node) throws XMLStreamException {
        if (this.has(node, element.getModelName())) {
            writer.writeStartElement(element.getLocalName());
            this.writeAttribute(writer, element, node);
            writer.writeEndElement();
        }
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Element element, ModelNode node) throws XMLStreamException {
        String value;
        if (this.has(node, element.getModelName()) && !element.sameAsDefault(value = node.get(element.getModelName()).asString())) {
            writer.writeAttribute(element.getLocalName(), value);
        }
    }

    private static ModelNode createAddSubsystemOperation() {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", "modeshape");
        return subsystem;
    }
}

