/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.jcr.RepositoryException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.Reflection;
import org.modeshape.jboss.subsystem.JBossManagedI18n;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

public final class EngineService
implements Service<JcrEngine>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final InjectedValue<JcrRepository> jcrRepositoryInjector = new InjectedValue();
    private JcrEngine engine = new JcrEngine();

    public EngineService() {
        this.engine = null;
    }

    public EngineService(JcrEngine engine) {
        CheckArg.isNotNull((Object)engine, (String)"engine");
        this.engine = engine;
    }

    public InjectedValue<JcrRepository> getJcrRepositoryInjector() {
        return this.jcrRepositoryInjector;
    }

    public JcrEngine getValue() throws IllegalStateException, IllegalArgumentException {
        return this.getEngine();
    }

    public void start(StartContext context) {
        this.engine.start();
    }

    public void stop(StopContext arg0) {
        this.engine.shutdown();
    }

    protected synchronized JcrEngine getEngine() {
        return this.engine;
    }

    public synchronized boolean isRunning() {
        if (this.engine == null) {
            return false;
        }
        try {
            return this.engine.getState().equals((Object)JcrEngine.State.RUNNING);
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public Collection<String> getRepositories() {
        if (!this.isRunning()) {
            return Collections.emptyList();
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        ArrayList<String> repositories = new ArrayList<String>();
        for (String repositoryName : engine.getRepositoryNames()) {
            repositories.add(repositoryName);
        }
        return repositories;
    }

    public JcrRepository getRepository(String repositoryName) {
        if (!this.isRunning()) {
            return null;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        try {
            return engine.getRepository(repositoryName);
        }
        catch (RepositoryException e) {
            Logger.getLogger(this.getClass()).error((Throwable)e, JBossManagedI18n.errorGettingRepositoryFromEngine, new Object[]{repositoryName});
            return null;
        }
    }

    public String getRepositoryVersion(String repositoryName) {
        String version = null;
        JcrRepository repository = this.getRepository(repositoryName);
        if (repository != null) {
            version = repository.getDescriptor("jcr.specification.name") + " " + repository.getDescriptor("jcr.specification.version");
        }
        return version;
    }

    public int getQueryActivity() {
        if (!this.isRunning()) {
            return 0;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        return 0;
    }

    public int getSaveActivity() {
        if (!this.isRunning()) {
            return 0;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        return 0;
    }

    public Object getSessionActivity() {
        if (!this.isRunning()) {
            return null;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        return 0;
    }

    public boolean removeLock(String lockId) {
        if (!this.isRunning()) {
            return false;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        return false;
    }

    public boolean terminateSession(String sessionId) {
        if (!this.isRunning()) {
            return false;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        return false;
    }

    public static class ManagedProperty {
        private static final long serialVersionUID = 1L;
        private String name;
        private String label;
        private String description;
        private String value;

        public ManagedProperty() {
        }

        public ManagedProperty(String label, String currentValue) {
            this.setLabel(label);
            this.value = currentValue;
        }

        public ManagedProperty(Reflection.Property property, String currentValue) {
            this.setName(property.getName());
            this.setLabel(property.getLabel());
            this.setDescription(property.getDescription());
            this.value = currentValue;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum Component {
        CONNECTOR,
        SEQUENCER,
        CONNECTIONPOOL,
        SEQUENCINGSERVICE,
        REPOSITORY;

    }
}

