/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.mimetype;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.api.mimetype.MimeTypeDetector;
import org.modeshape.jcr.mimetype.ApertureMimeTypeDetector;
import org.modeshape.jcr.mimetype.ExtensionBasedMimeTypeDetector;

@ThreadSafe
public final class MimeTypeDetectors
implements MimeTypeDetector {
    private static final List<MimeTypeDetector> MIME_TYPE_DETECTORS = new ArrayList<MimeTypeDetector>();

    public String mimeTypeOf(String name, InputStream content) throws IOException {
        String detectedMimeType = this.detectMimeTypeUsingDetectors(name, content);
        return detectedMimeType != null ? detectedMimeType : this.detectFallbackMimeType(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String detectFallbackMimeType(InputStream content) throws IOException {
        this.tryMark(content);
        try {
            int chr = content.read();
            while (chr >= 0) {
                if (chr == 0) {
                    String string = "application/octet-stream";
                    return string;
                }
                chr = content.read();
            }
        }
        catch (IOException meansTooManyBytesRead) {
            String string = "application/octet-stream";
            return string;
        }
        finally {
            this.tryReset(content);
        }
        return "text/plain";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String detectMimeTypeUsingDetectors(String name, InputStream content) throws IOException {
        for (MimeTypeDetector detector : MIME_TYPE_DETECTORS) {
            try {
                this.tryMark(content);
                String mimeType = detector.mimeTypeOf(name, content);
                if (mimeType == null) continue;
                String string = mimeType;
                return string;
            }
            finally {
                this.tryReset(content);
            }
        }
        return null;
    }

    private void tryMark(InputStream content) {
        if (content != null && content.markSupported()) {
            content.mark(Integer.MAX_VALUE);
        }
    }

    private void tryReset(InputStream content) throws IOException {
        if (content != null && content.markSupported()) {
            content.reset();
        }
    }

    static {
        try {
            Class.forName("org.semanticdesktop.aperture.mime.identifier.magic.MagicMimeTypeIdentifier", false, MimeTypeDetectors.class.getClassLoader());
            MIME_TYPE_DETECTORS.add(new ApertureMimeTypeDetector());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        MIME_TYPE_DETECTORS.add(new ExtensionBasedMimeTypeDetector());
    }
}

