/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene.basic;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.modeshape.common.util.Logger;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.lucene.LuceneException;
import org.modeshape.jcr.query.lucene.LuceneProcessingContext;
import org.modeshape.jcr.query.lucene.LuceneQuery;
import org.modeshape.jcr.query.lucene.LuceneQueryEngine;
import org.modeshape.jcr.query.lucene.LuceneQueryFactory;
import org.modeshape.jcr.query.lucene.LuceneSchema;
import org.modeshape.jcr.query.lucene.basic.BasicTupleCollector;
import org.modeshape.jcr.query.lucene.basic.BinaryInfo;
import org.modeshape.jcr.query.lucene.basic.NodeInfo;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

public class BasicLuceneSchema
implements LuceneSchema {
    private final SearchFactoryImplementor searchFactory;
    private final NamespaceRegistry namespaces;
    private final ExecutionContext context;
    private final Logger logger;

    public BasicLuceneSchema(ExecutionContext context, SearchFactoryImplementor searchFactory) {
        this.searchFactory = searchFactory;
        this.context = context;
        this.namespaces = context.getNamespaceRegistry();
        this.logger = Logger.getLogger(this.getClass());
        assert (this.searchFactory != null);
    }

    protected final String stringFrom(Path path) {
        if (path.isRoot()) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (Path.Segment segment : path) {
            sb.append('/');
            sb.append(segment.getName().getString(this.namespaces));
            sb.append('[');
            sb.append(segment.getIndex());
            sb.append(']');
        }
        return sb.toString();
    }

    protected final String stringFrom(Name name) {
        return name.getString(this.namespaces);
    }

    protected final NodeInfo nodeInfo(String id, String workspace, Path path, Collection<Property> properties) {
        String pathStr = null;
        String name = null;
        String localName = null;
        int depth = 0;
        if (path.isRoot()) {
            pathStr = "/";
            name = "";
            localName = "";
            depth = 0;
        } else {
            pathStr = this.stringFrom(path);
            Name nodeName = path.getLastSegment().getName();
            name = this.stringFrom(nodeName);
            localName = nodeName.getLocalName();
            depth = path.size();
        }
        StringBuilder fullText = null;
        HashMap<String, Object> propertiesByName = new HashMap<String, Object>();
        for (Property property : properties) {
            String propName = this.stringFrom(property.getName());
            if (property.isEmpty()) continue;
            if (property.isSingle()) {
                propertiesByName.put(propName, property.getFirstValue());
                continue;
            }
            propertiesByName.put(propName, property.getValuesAsArray());
        }
        String fullTextStr = fullText != null ? fullText.toString() : null;
        return new NodeInfo(id, workspace, pathStr, name, localName, depth, propertiesByName, fullTextStr);
    }

    @Override
    public void addToIndex(String workspace, NodeKey key, Path path, Collection<Property> properties, TransactionContext txnCtx) {
        String id = key.toString();
        NodeInfo nodeInfo = this.nodeInfo(id, workspace, path, properties);
        Work work = new Work((Object)nodeInfo, (Serializable)((Object)id), WorkType.ADD);
        this.searchFactory.getWorker().performWork(work, txnCtx);
    }

    @Override
    public void updateIndex(String workspace, NodeKey key, Path path, Iterator<Property> propertiesIterator, TransactionContext txnCtx) {
        LinkedList<Property> props = new LinkedList<Property>();
        while (propertiesIterator.hasNext()) {
            props.add(propertiesIterator.next());
        }
        this.updateIndex(workspace, key, path, props, txnCtx);
    }

    @Override
    public void updateIndex(String workspace, NodeKey key, Path path, Collection<Property> properties, TransactionContext txnCtx) {
        String id = key.toString();
        NodeInfo nodeInfo = this.nodeInfo(id, workspace, path, properties);
        Work work = new Work((Object)nodeInfo, (Serializable)((Object)id), WorkType.UPDATE);
        this.searchFactory.getWorker().performWork(work, txnCtx);
    }

    @Override
    public void removeFromIndex(String workspace, Iterable<NodeKey> keys, TransactionContext txnCtx) {
        Worker worker = this.searchFactory.getWorker();
        for (NodeKey key : keys) {
            String id = key.toString();
            Work work = new Work(NodeInfo.class, (Serializable)((Object)id), WorkType.PURGE);
            worker.performWork(work, txnCtx);
        }
    }

    @Override
    public void removeAllFromIndex(String workspace, TransactionContext txnCtx) {
        Work work = new Work(Object.class, (Serializable)null, WorkType.PURGE_ALL);
        this.searchFactory.getWorker().performWork(work, txnCtx);
    }

    @Override
    public void addBinaryToIndex(Binary binary, TransactionContext txnCtx) {
        String sha1 = binary.getHexHash();
        try {
            String text = this.context.getBinaryStore().getText((org.modeshape.jcr.value.Binary)binary);
            BinaryInfo binaryInfo = new BinaryInfo(sha1, text);
            Work binaryWork = new Work((Object)binaryInfo, (Serializable)((Object)binaryInfo.getSha1()), WorkType.ADD);
            this.searchFactory.getWorker().performWork(binaryWork, txnCtx);
        }
        catch (Throwable t) {
            this.logger.error(t, JcrI18n.errorAddingBinaryTextToIndex, new Object[]{sha1});
        }
    }

    @Override
    public void removeBinariesFromIndex(Iterable<String> sha1s, TransactionContext txnCtx) {
        Worker worker = this.searchFactory.getWorker();
        for (String sha1 : sha1s) {
            Work binaryWork = new Work(BinaryInfo.class, (Serializable)((Object)sha1), WorkType.PURGE);
            worker.performWork(binaryWork, txnCtx);
        }
    }

    @Override
    public LuceneQuery createQuery(List<Constraint> andedConstraints, LuceneProcessingContext processingContext) throws LuceneException {
        try {
            LuceneQuery queries = new LuceneQuery("nodeinfo");
            LuceneQueryFactory queryFactory = processingContext.getQueryFactory();
            for (Constraint andedConstraint : andedConstraints) {
                Query constraintQuery = queryFactory.createQuery(andedConstraint);
                if (constraintQuery != null) {
                    queries.addQuery(constraintQuery);
                    continue;
                }
                queries.addConstraintForPostprocessing(andedConstraint);
            }
            return queries;
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    @Override
    public LuceneQueryEngine.TupleCollector createTupleCollector(QueryContext queryContext, QueryResults.Columns columns) {
        return new BasicTupleCollector(queryContext, columns);
    }
}

