/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene.basic;

import java.util.Map;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Store;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.query.lucene.basic.NodeInfoBridge;

@Immutable
@Indexed(index="nodeinfo")
public class NodeInfo {
    @DocumentId(name="::id")
    private final String id;
    @Field(name="::wks", analyze=Analyze.NO, store=Store.NO, index=Index.YES)
    private final String workspace;
    @Field(name="::pth", analyze=Analyze.NO, store=Store.NO, index=Index.YES)
    private final String path;
    @Field(name="::nam", analyze=Analyze.NO, store=Store.NO, index=Index.YES)
    private final String name;
    @Field(name="::loc", analyze=Analyze.NO, store=Store.NO, index=Index.YES)
    private final String localName;
    @Field(name="::dep", analyze=Analyze.NO, store=Store.NO, index=Index.YES)
    @NumericField(forField="::dep")
    private final int depth;
    @Field(analyze=Analyze.NO, store=Store.NO)
    @FieldBridge(impl=NodeInfoBridge.class)
    private final Map<String, Object> properties;
    @Field(name="::fts", analyze=Analyze.YES, store=Store.NO, index=Index.YES)
    private final String fullText;

    public NodeInfo(String nodeKey, String workspace, String path, String localName, String name, int depth, Map<String, Object> properties, String fullText) {
        this.id = nodeKey;
        this.workspace = workspace;
        this.path = path;
        this.name = name;
        this.localName = localName;
        this.depth = depth;
        this.properties = properties;
        this.fullText = fullText;
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getDepth() {
        return this.depth;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getFullText() {
        return this.fullText;
    }

    public String toString() {
        return this.id + " @ " + this.path + " in '" + this.workspace + "' with " + this.properties;
    }
}

