/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.value.Binary;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.FileLocks;
import org.modeshape.jcr.value.binary.NamedLocks;
import org.modeshape.jcr.value.binary.SharedLockingInputStream;

@ThreadSafe
public class FileSystemBinaryStore
extends AbstractBinaryStore {
    private static final ConcurrentHashMap<String, FileSystemBinaryStore> INSTANCES = new ConcurrentHashMap();
    private static final boolean LOCK_WHEN_REMOVING_UNUSED_FILES;
    private static final String TEMP_FILE_PREFIX = "ms-fs-binstore";
    private static final String TEMP_FILE_SUFFIX = "hashing";
    protected static final String TRASH_DIRECTORY_NAME = "trash";
    private final File directory;
    private final File trash;
    private final NamedLocks locks = new NamedLocks();
    private volatile boolean initialized = false;

    public static FileSystemBinaryStore create(File directory) {
        FileSystemBinaryStore existing;
        String key = directory.getAbsolutePath();
        FileSystemBinaryStore store = INSTANCES.get(key);
        if (store == null && (existing = INSTANCES.putIfAbsent(key, store = new FileSystemBinaryStore(directory))) != null) {
            store = existing;
        }
        return store;
    }

    protected FileSystemBinaryStore(File directory) {
        this.directory = directory;
        this.trash = new File(this.directory, TRASH_DIRECTORY_NAME);
    }

    public File getDirectory() {
        return this.directory;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Binary storeValue(InputStream stream) throws BinaryStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void moveFileExclusively(File original, File destination) throws BinaryStoreException {
        try {
            destination.getParentFile().mkdirs();
            FileLocks.WrappedLock fileLock = FileLocks.get().writeLock(original);
            try {
                if (original.renameTo(destination)) {
                    return;
                }
            }
            finally {
                fileLock.unlock();
            }
            int bufferSize = AbstractBinaryStore.bestBufferSize(original.length());
            fileLock = FileLocks.get().writeLock(destination);
            try {
                FileChannel destinationChannel = fileLock.lockedFileChannel();
                OutputStream output = Channels.newOutputStream(destinationChannel);
                output = new BufferedOutputStream(output, bufferSize);
                RandomAccessFile originalRaf = new RandomAccessFile(original, "r");
                FileChannel originalChannel = originalRaf.getChannel();
                InputStream input = Channels.newInputStream(originalChannel);
                input = new BufferedInputStream(input, bufferSize);
                IoUtil.write((InputStream)input, (OutputStream)output, (int)bufferSize);
            }
            finally {
                try {
                    fileLock.unlock();
                }
                finally {
                    original.delete();
                }
            }
        }
        catch (IOException e) {
            throw new BinaryStoreException(e);
        }
    }

    protected final File findFile(File directory, BinaryKey key, boolean createParentDirsIfMissing) throws BinaryStoreException {
        if (!this.initialized) {
            this.initializeStorage(directory);
            this.initialized = true;
        }
        String sha1 = key.toString();
        File first = new File(directory, sha1.substring(0, 2));
        File second = new File(first, sha1.substring(2, 4));
        File third = new File(second, sha1.substring(4, 6));
        if (createParentDirsIfMissing) {
            third.mkdirs();
        }
        File file = new File(third, sha1);
        return file;
    }

    @Override
    public InputStream getInputStream(BinaryKey key) throws BinaryStoreException {
        File persistedFile = this.findFile(this.directory, key, false);
        if (!persistedFile.exists() || !persistedFile.canRead()) {
            File trashedFile = this.findFile(this.trash, key, true);
            if (!trashedFile.exists() || !trashedFile.canRead()) {
                throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{key, this.directory.getPath()}));
            }
            this.moveFileExclusively(trashedFile, persistedFile);
            this.pruneEmptyDirectories(this.trash, trashedFile);
        }
        return new SharedLockingInputStream(key, persistedFile, this.locks);
    }

    protected void initializeStorage(File directory) throws BinaryStoreException {
    }

    @Override
    public void markAsUnused(Iterable<BinaryKey> keys) throws BinaryStoreException {
        if (keys == null) {
            return;
        }
        for (BinaryKey key : keys) {
            this.markAsUnused(key);
        }
    }

    protected void markAsUnused(BinaryKey key) throws BinaryStoreException {
        File persisted = this.findFile(this.directory, key, false);
        if (persisted == null || !persisted.exists()) {
            return;
        }
        File trashed = this.findFile(this.trash, key, true);
        this.moveFileExclusively(persisted, trashed);
        this.touch(trashed);
        this.pruneEmptyDirectories(this.directory, persisted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void touch(File file) throws BinaryStoreException {
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            FileLocks.WrappedLock fileLock = FileLocks.get().writeLock(file);
            try {
                raf.setLength(raf.length());
            }
            finally {
                raf.close();
                fileLock.unlock();
            }
        }
        catch (IOException e) {
            throw new BinaryStoreException(e);
        }
    }

    protected void pruneEmptyDirectories(File directory, File removeable) {
        assert (directory != null);
        assert (removeable != null);
        if (directory.equals(removeable)) {
            return;
        }
        assert (this.isAncestor(directory, removeable));
        while (!removeable.equals(directory)) {
            if (removeable.exists() && !removeable.delete()) {
                return;
            }
            removeable = removeable.getParentFile();
        }
    }

    private boolean isAncestor(File ancestor, File descendant) {
        for (File parent = descendant; parent != null; parent = parent.getParentFile()) {
            if (!parent.equals(ancestor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeValuesUnusedLongerThan(long minimumAge, TimeUnit unit) throws BinaryStoreException {
        long oldestTimestamp = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(minimumAge, unit);
        try {
            this.removeFilesOlderThan(oldestTimestamp, this.trash);
        }
        catch (IOException e) {
            throw new BinaryStoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFilesOlderThan(long oldestTimestamp, File parentDirectory) throws IOException {
        if (parentDirectory == null || !parentDirectory.exists() || parentDirectory.isFile()) {
            return;
        }
        boolean removed = false;
        for (File fileOrDir : parentDirectory.listFiles()) {
            File file;
            if (fileOrDir == null || !fileOrDir.exists()) continue;
            if (fileOrDir.isDirectory()) {
                this.removeFilesOlderThan(oldestTimestamp, fileOrDir);
                continue;
            }
            if (!fileOrDir.isFile() || (file = fileOrDir).lastModified() >= oldestTimestamp) continue;
            if (LOCK_WHEN_REMOVING_UNUSED_FILES) {
                FileLocks.WrappedLock fileLock = FileLocks.get().tryWriteLock(file);
                if (fileLock == null) continue;
                try {
                    file.delete();
                    removed = true;
                    continue;
                }
                finally {
                    fileLock.unlock();
                }
            }
            if (!file.delete()) continue;
            removed = true;
        }
        if (removed) {
            this.pruneEmptyDirectories(this.trash, parentDirectory);
        }
    }

    @Override
    public String getText(Binary binary) throws BinaryStoreException {
        return null;
    }

    @Override
    public String getMimeType(Binary binary, String name) throws IOException, RepositoryException {
        return this.detector().mimeTypeOf(name, binary.getStream());
    }

    static {
        String osName = System.getProperty("os.name");
        LOCK_WHEN_REMOVING_UNUSED_FILES = osName == null || !osName.toLowerCase().contains("windows");
    }
}

