/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

enum Element {
    UNKNOWN(null),
    REPOSITORY_ELEMENT("repository"),
    REPOSITORY_NAME_ATTRIBUTE("name", "name", ModelType.STRING, true, null),
    REPOSITORY_JNDI_NAME_ATTRIBUTE("jndiName", "jndiName", ModelType.STRING, false, null),
    SEQUENCING_ELEMENT("sequencing"),
    SEQUENCER_ELEMENT("sequencer"),
    SEQUENCER_NAME_ATTRIBUTE("name", "sequencer-name", ModelType.STRING, false, null),
    SEQUENCER_DESCRIPTION_ATTRIBUTE("description", "sequencer-description", ModelType.STRING, false, null),
    SEQUENCER_TYPE_ATTRIBUTE("type", "sequencer-type", ModelType.STRING, false, null),
    SEQUENCER_EXPRESSIONS_ATTRIBUTE("path_expressions", "sequencer-path-expressions", ModelType.STRING, false, null);

    private final String name;
    private final String modelName;
    private final boolean required;
    private final ModelType modelType;
    private final String defaultValue;
    private static final Map<String, Element> elements;

    private Element(String name) {
        this.name = name;
        this.modelName = name;
        this.required = false;
        this.modelType = null;
        this.defaultValue = null;
    }

    private Element(String name, String modelName, ModelType type, boolean required, String defltValue) {
        this.name = name;
        this.modelName = modelName;
        this.modelType = type;
        this.required = required;
        this.defaultValue = defltValue;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getModelName() {
        return this.modelName;
    }

    public static Element forName(String localName, Element parentNode) {
        String modelName = parentNode.getLocalName() + "-" + localName;
        Element element = elements.get(modelName);
        return element == null ? UNKNOWN : element;
    }

    public static Element forName(String localName) {
        Element element = elements.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public void describe(ModelNode node, String type, ResourceBundle bundle) {
        String name = this.getModelName();
        node.get(new String[]{type, name, "type"}).set(this.modelType);
        node.get(new String[]{type, name, "description"}).set(this.getDescription(bundle));
        node.get(new String[]{type, name, "required"}).set(this.required);
        node.get(new String[]{type, name, "max-occurs"}).set(1);
        if (this.defaultValue != null) {
            if (ModelType.INT == this.modelType) {
                node.get(new String[]{type, name, "default"}).set(Integer.parseInt(this.defaultValue));
            } else if (ModelType.BOOLEAN == this.modelType) {
                node.get(new String[]{type, name, "default"}).set(Boolean.parseBoolean(this.defaultValue));
            } else if (ModelType.LONG == this.modelType) {
                node.get(new String[]{type, name, "default"}).set(Long.parseLong(this.defaultValue));
            } else if (ModelType.STRING == this.modelType) {
                node.get(new String[]{type, name, "default"}).set(this.defaultValue);
            } else {
                throw new RuntimeException();
            }
        }
    }

    public void populate(ModelNode operation, ModelNode model) {
        if (this.getModelName() == null) {
            return;
        }
        if (operation.hasDefined(this.getModelName())) {
            if (ModelType.STRING == this.modelType) {
                model.get(this.getModelName()).set(operation.get(this.getModelName()).asString());
            } else if (ModelType.INT == this.modelType) {
                model.get(this.getModelName()).set(operation.get(this.getModelName()).asInt());
            } else if (ModelType.LONG == this.modelType) {
                model.get(this.getModelName()).set(operation.get(this.getModelName()).asLong());
            } else if (ModelType.BOOLEAN == this.modelType) {
                model.get(this.getModelName()).set(operation.get(this.getModelName()).asBoolean());
            } else {
                throw new RuntimeException();
            }
        }
    }

    public boolean isDefined(ModelNode node) {
        return node.hasDefined(this.getModelName());
    }

    public int asInt(ModelNode node) {
        return node.get(this.getModelName()).asInt();
    }

    public long asLong(ModelNode node) {
        return node.get(this.getModelName()).asLong();
    }

    public String asString(ModelNode node) {
        return node.get(this.getModelName()).asString();
    }

    public boolean asBoolean(ModelNode node) {
        return node.get(this.getModelName()).asBoolean();
    }

    public boolean isLike(ModelNode node) {
        Set keys = node.keys();
        for (String key : keys) {
            if (!key.startsWith(this.name)) continue;
            return true;
        }
        return false;
    }

    public String getDescription(ResourceBundle bundle) {
        return bundle.getString(this.modelName + ".describe");
    }

    public boolean sameAsDefault(String value) {
        if (this.defaultValue == null) {
            return value == null;
        }
        return this.defaultValue.equalsIgnoreCase(value);
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getModelName();
            if (name == null) continue;
            map.put(name, element);
        }
        elements = map;
    }
}

