/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.AccessDeniedException;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventJournal;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.RepositoryStatistics;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.change.AbstractNodeChange;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.NodeAdded;
import org.modeshape.jcr.cache.change.NodeMoved;
import org.modeshape.jcr.cache.change.NodeRemoved;
import org.modeshape.jcr.cache.change.NodeReordered;
import org.modeshape.jcr.cache.change.Observable;
import org.modeshape.jcr.cache.change.PropertyAdded;
import org.modeshape.jcr.cache.change.PropertyChanged;
import org.modeshape.jcr.cache.change.PropertyRemoved;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;

@ThreadSafe
class JcrObservationManager
implements ObservationManager,
ChangeSetListener {
    static final String OBSERVATION_USER_DATA_KEY = "org.modeshape.jcr.observation.userdata";
    static final String MOVE_FROM_KEY = "srcAbsPath";
    static final String MOVE_TO_KEY = "destAbsPath";
    static final String ORDER_DEST_KEY = "srcChildRelPath";
    static final String ORDER_SRC_KEY = "destChildRelPath";
    private final Observable repositoryObservable;
    private final Map<EventListener, JcrListenerAdapter> listeners;
    private final JcrSession session;
    private final String workspaceName;
    private final String systemWorkspaceName;
    private final RepositoryStatistics repositoryStatistics;
    private final ConcurrentHashMap<Integer, AtomicInteger> changesReceivedAndDispatched;
    private final ReadWriteLock listenersLock;

    JcrObservationManager(JcrSession session, Observable repositoryObservable, RepositoryStatistics statistics) {
        CheckArg.isNotNull((Object)session, (String)"session");
        CheckArg.isNotNull((Object)repositoryObservable, (String)"repositoryObservable");
        CheckArg.isNotNull((Object)statistics, (String)"statistics");
        this.session = session;
        this.workspaceName = this.session.getWorkspace().getName();
        this.systemWorkspaceName = this.session.repository().systemWorkspaceName();
        this.repositoryObservable = repositoryObservable;
        this.repositoryObservable.register(this);
        this.listenersLock = new ReentrantReadWriteLock(true);
        this.listeners = new HashMap<EventListener, JcrListenerAdapter>();
        this.repositoryStatistics = statistics;
        this.changesReceivedAndDispatched = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName, boolean noLocal) throws RepositoryException {
        CheckArg.isNotNull((Object)listener, (String)"listener");
        this.checkSession();
        JcrListenerAdapter adapter = new JcrListenerAdapter(listener, eventTypes, absPath, isDeep, uuid, nodeTypeName, noLocal);
        try {
            this.listenersLock.writeLock().lock();
            this.repositoryObservable.unregister(adapter);
            this.repositoryObservable.register(adapter);
            this.listeners.put(listener, adapter);
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    void checkSession() throws RepositoryException {
        this.session.checkLive();
    }

    JcrNodeTypeManager getNodeTypeManager() throws RepositoryException {
        return this.session.getWorkspace().getNodeTypeManager();
    }

    @Override
    public void notify(ChangeSet changeSet) {
        this.incrementEventQueueStatistic(changeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementEventQueueStatistic(ChangeSet changeSet) {
        this.repositoryStatistics.increment(ValueMetric.EVENT_QUEUE_SIZE);
        if (!this.changesReceivedAndDispatched.containsKey(changeSet.hashCode())) {
            try {
                this.listenersLock.readLock().lock();
                this.changesReceivedAndDispatched.putIfAbsent(changeSet.hashCode(), new AtomicInteger(this.listeners.size()));
            }
            finally {
                this.listenersLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementEventQueueStatistic(ChangeSet changeSet) {
        if (this.changesReceivedAndDispatched.containsKey(changeSet.hashCode())) {
            int timesProcessed = this.changesReceivedAndDispatched.get(changeSet.hashCode()).decrementAndGet();
            if (timesProcessed == 0) {
                this.repositoryStatistics.decrement(ValueMetric.EVENT_QUEUE_SIZE);
                this.changesReceivedAndDispatched.remove(changeSet.hashCode());
            }
        } else {
            try {
                this.listenersLock.readLock().lock();
                this.changesReceivedAndDispatched.putIfAbsent(changeSet.hashCode(), new AtomicInteger(this.listeners.size() - 1));
            }
            finally {
                this.listenersLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventListenerIterator getRegisteredEventListeners() throws RepositoryException {
        this.checkSession();
        try {
            this.listenersLock.readLock().lock();
            JcrEventListenerIterator jcrEventListenerIterator = new JcrEventListenerIterator((Collection<EventListener>)Collections.unmodifiableSet(this.listeners.keySet()));
            return jcrEventListenerIterator;
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
    }

    final String stringFor(Path path) {
        return this.session.stringFactory().create(path);
    }

    final String stringFor(Path.Segment segment) {
        return this.session.stringFactory().create(segment);
    }

    final String stringFor(Name name) {
        return this.session.stringFactory().create(name);
    }

    final PathFactory pathFactory() {
        return this.session.pathFactory();
    }

    String getSessionId() {
        return this.session.context().getProcessId();
    }

    final String getWorkspaceName() {
        return this.workspaceName;
    }

    final String getSystemWorkspaceName() {
        return this.systemWorkspaceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllEventListeners() {
        try {
            this.listenersLock.writeLock().lock();
            for (JcrListenerAdapter listener : this.listeners.values()) {
                assert (listener != null);
                this.repositoryObservable.unregister(listener);
            }
            this.listeners.clear();
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(EventListener listener) throws RepositoryException {
        this.checkSession();
        CheckArg.isNotNull((Object)listener, (String)"listener");
        try {
            this.listenersLock.writeLock().lock();
            JcrListenerAdapter jcrListener = this.listeners.remove(listener);
            if (jcrListener != null) {
                this.repositoryObservable.unregister(jcrListener);
            }
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    public void setUserData(String userData) {
        this.session.addContextData(OBSERVATION_USER_DATA_KEY, userData);
    }

    public EventJournal getEventJournal() {
        return null;
    }

    public EventJournal getEventJournal(int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName) {
        return null;
    }

    @NotThreadSafe
    class JcrListenerAdapter
    implements ChangeSetListener {
        private final Logger logger = Logger.getLogger(this.getClass());
        private final String absPath;
        private final EventListener delegate;
        private final int eventTypes;
        private final boolean isDeep;
        private final String[] nodeTypeNames;
        private final boolean noLocal;
        private final String[] uuids;

        public JcrListenerAdapter(EventListener delegate, int eventTypes, String absPath, boolean isDeep, String[] uuids, String[] nodeTypeNames, boolean noLocal) {
            assert (delegate != null);
            this.delegate = delegate;
            this.eventTypes = eventTypes;
            this.absPath = absPath;
            this.isDeep = isDeep;
            this.uuids = uuids;
            this.nodeTypeNames = nodeTypeNames;
            this.noLocal = noLocal;
        }

        @Override
        public void notify(ChangeSet changeSet) {
            JcrObservationManager.this.decrementEventQueueStatistic(changeSet);
            if (this.shouldReject(changeSet)) {
                return;
            }
            ArrayList<Event> events = new ArrayList<Event>();
            String userData = changeSet.getUserData().get(JcrObservationManager.OBSERVATION_USER_DATA_KEY);
            JcrEventBundle bundle = new JcrEventBundle(changeSet.getTimestamp(), changeSet.getUserId(), userData);
            for (Change change : changeSet) {
                this.processChange(events, bundle, change);
            }
            if (!events.isEmpty()) {
                this.delegate.onEvent((EventIterator)new JcrEventIterator((Collection<Event>)events));
            }
        }

        private boolean shouldReject(ChangeSet changeSet) {
            return !this.acceptBasedOnOriginatingSession(changeSet) || !this.acceptBasedOnOriginatingWorkspace(changeSet);
        }

        private void processChange(Collection<Event> events, JcrEventBundle bundle, Change change) {
            if (!(change instanceof AbstractNodeChange)) {
                return;
            }
            AbstractNodeChange nodeChange = (AbstractNodeChange)change;
            if (this.shouldReject(nodeChange)) {
                return;
            }
            Path newPath = nodeChange.getPath();
            String nodeId = nodeChange.getKey().getIdentifier();
            if (nodeChange instanceof NodeMoved) {
                NodeMoved nodeMovedChange = (NodeMoved)nodeChange;
                Path oldPath = nodeMovedChange.getOldPath();
                if (this.eventListenedFor(32)) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put(JcrObservationManager.MOVE_FROM_KEY, JcrObservationManager.this.stringFor(oldPath));
                    info.put(JcrObservationManager.MOVE_TO_KEY, JcrObservationManager.this.stringFor(newPath));
                    events.add(new JcrEvent(bundle, 32, JcrObservationManager.this.stringFor(newPath), nodeId, Collections.unmodifiableMap(info)));
                }
                this.fireExtraEventsForMove(events, bundle, newPath, nodeId, oldPath);
            } else if (nodeChange instanceof NodeReordered) {
                NodeReordered nodeReordered = (NodeReordered)nodeChange;
                Path oldPath = nodeReordered.getOldPath();
                if (this.eventListenedFor(32)) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put(JcrObservationManager.ORDER_DEST_KEY, JcrObservationManager.this.stringFor(oldPath.getLastSegment()));
                    info.put(JcrObservationManager.ORDER_SRC_KEY, JcrObservationManager.this.stringFor(newPath.getLastSegment()));
                    events.add(new JcrEvent(bundle, 32, JcrObservationManager.this.stringFor(newPath), nodeId, Collections.unmodifiableMap(info)));
                }
                this.fireExtraEventsForMove(events, bundle, newPath, nodeId, oldPath);
            } else if (nodeChange instanceof NodeAdded && this.eventListenedFor(1)) {
                events.add(new JcrEvent(bundle, 1, JcrObservationManager.this.stringFor(newPath), nodeId));
            } else if (nodeChange instanceof NodeRemoved && this.eventListenedFor(2)) {
                events.add(new JcrEvent(bundle, 2, JcrObservationManager.this.stringFor(newPath), nodeId));
            } else if (nodeChange instanceof PropertyChanged && this.eventListenedFor(16)) {
                Name propertyName = ((PropertyChanged)nodeChange).getNewProperty().getName();
                Path propertyPath = JcrObservationManager.this.pathFactory().create(newPath, JcrObservationManager.this.stringFor(propertyName));
                events.add(new JcrEvent(bundle, 16, JcrObservationManager.this.stringFor(propertyPath), nodeId));
            } else if (nodeChange instanceof PropertyAdded && this.eventListenedFor(4)) {
                Name propertyName = ((PropertyAdded)nodeChange).getProperty().getName();
                Path propertyPath = JcrObservationManager.this.pathFactory().create(newPath, JcrObservationManager.this.stringFor(propertyName));
                events.add(new JcrEvent(bundle, 4, JcrObservationManager.this.stringFor(propertyPath), nodeId));
            } else if (nodeChange instanceof PropertyRemoved && this.eventListenedFor(8)) {
                Name propertyName = ((PropertyRemoved)nodeChange).getProperty().getName();
                Path propertyPath = JcrObservationManager.this.pathFactory().create(newPath, propertyName);
                events.add(new JcrEvent(bundle, 8, JcrObservationManager.this.stringFor(propertyPath), nodeId));
            }
        }

        private void fireExtraEventsForMove(Collection<Event> events, JcrEventBundle bundle, Path newPath, String nodeId, Path oldPath) {
            if (this.eventListenedFor(1)) {
                events.add(new JcrEvent(bundle, 1, JcrObservationManager.this.stringFor(newPath), nodeId));
            }
            if (this.eventListenedFor(2)) {
                events.add(new JcrEvent(bundle, 2, JcrObservationManager.this.stringFor(oldPath), nodeId));
            }
        }

        private boolean shouldReject(AbstractNodeChange nodeChange) {
            return !this.acceptBasedOnNodeTypeName(nodeChange) || !this.acceptBasedOnPath(nodeChange) || !this.acceptBasedOnUuid(nodeChange) || !this.acceptBasedOnPermission(nodeChange);
        }

        private boolean eventListenedFor(int eventType) {
            return (this.eventTypes & eventType) == eventType;
        }

        private boolean acceptBasedOnPermission(AbstractNodeChange nodeChange) {
            try {
                JcrObservationManager.this.session.checkPermission(this.parentNodePathOfChange(nodeChange), "read");
                return true;
            }
            catch (AccessDeniedException e) {
                return false;
            }
        }

        private boolean acceptBasedOnOriginatingWorkspace(ChangeSet changeSet) {
            boolean sameWorkspace = JcrObservationManager.this.getWorkspaceName().equalsIgnoreCase(changeSet.getWorkspaceName());
            boolean isSystemWorkspace = JcrObservationManager.this.getSystemWorkspaceName().equalsIgnoreCase(changeSet.getWorkspaceName());
            return sameWorkspace || isSystemWorkspace;
        }

        private boolean acceptBasedOnOriginatingSession(ChangeSet changeSet) {
            if (this.noLocal) {
                return !JcrObservationManager.this.getSessionId().equals(changeSet.getProcessKey());
            }
            return true;
        }

        private boolean acceptBasedOnNodeTypeName(AbstractNodeChange change) {
            if (this.nodeTypeNames != null && this.nodeTypeNames.length == 0) {
                return false;
            }
            if (this.shouldCheckNodeType()) {
                String primaryTypeName = null;
                HashSet<String> mixinTypeNames = null;
                try {
                    Path parentPath = this.parentNodePathOfChange(change);
                    AbstractJcrNode parentNode = JcrObservationManager.this.session.node(parentPath);
                    mixinTypeNames = new HashSet<String>(parentNode.getMixinTypeNames().size());
                    for (Name mixinName : parentNode.getMixinTypeNames()) {
                        mixinTypeNames.add(JcrObservationManager.this.stringFor(mixinName));
                    }
                    primaryTypeName = JcrObservationManager.this.stringFor(parentNode.getPrimaryTypeName());
                    return JcrObservationManager.this.getNodeTypeManager().isDerivedFrom(this.nodeTypeNames, primaryTypeName, mixinTypeNames.toArray(new String[mixinTypeNames.size()]));
                }
                catch (RepositoryException e) {
                    this.logger.error((Throwable)e, JcrI18n.cannotPerformNodeTypeCheck, new Object[]{primaryTypeName, mixinTypeNames, this.nodeTypeNames});
                    return false;
                }
            }
            return true;
        }

        private boolean acceptBasedOnPath(AbstractNodeChange change) {
            if (!StringUtil.isBlank((String)this.absPath)) {
                Path matchPath = (Path)JcrObservationManager.this.session.pathFactory().create(this.absPath);
                Path parentPath = this.parentNodePathOfChange(change);
                return this.isDeep ? matchPath.isAtOrAbove(parentPath) : matchPath.equals(parentPath);
            }
            return true;
        }

        private boolean acceptBasedOnUuid(AbstractNodeChange change) {
            if (this.uuids != null && this.uuids.length == 0) {
                return false;
            }
            if (this.uuids != null && this.uuids.length > 0) {
                String matchUuidString = change.getKey().getIdentifier();
                Arrays.sort(this.uuids);
                return Arrays.binarySearch(this.uuids, matchUuidString) >= 0;
            }
            return true;
        }

        private Path parentNodePathOfChange(AbstractNodeChange change) {
            Path changePath = change.getPath();
            if (change instanceof PropertyAdded || change instanceof PropertyRemoved || change instanceof PropertyChanged) {
                return changePath;
            }
            return changePath.isRoot() ? changePath : changePath.getParent();
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof JcrListenerAdapter && this.delegate == ((JcrListenerAdapter)obj).delegate;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        private boolean shouldCheckNodeType() {
            return this.nodeTypeNames != null && this.nodeTypeNames.length > 0;
        }
    }

    @Immutable
    class JcrEvent
    implements Event {
        private final String id;
        private final String path;
        private final int type;
        private final JcrEventBundle bundle;
        private Map<String, String> info;

        JcrEvent(JcrEventBundle bundle, int type, String path, String id) {
            this.type = type;
            this.path = path;
            this.bundle = bundle;
            this.id = id;
        }

        JcrEvent(JcrEventBundle bundle, int type, String path, String id, Map<String, String> info) {
            this(bundle, type, path, id);
            this.info = info;
        }

        public String getPath() {
            return this.path;
        }

        public int getType() {
            return this.type;
        }

        public String getUserID() {
            return this.bundle.getUserID();
        }

        public long getDate() {
            return this.bundle.getDate().getMilliseconds();
        }

        public String getIdentifier() {
            return this.id;
        }

        public String getUserData() {
            return this.bundle.getUserData();
        }

        public Map<String, String> getInfo() {
            return Collections.unmodifiableMap(this.info);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            switch (this.type) {
                case 1: {
                    sb.append("Node added");
                    break;
                }
                case 2: {
                    sb.append("Node removed");
                    break;
                }
                case 4: {
                    sb.append("Property added");
                    break;
                }
                case 16: {
                    sb.append("Property changed");
                    break;
                }
                case 8: {
                    sb.append("Property removed");
                    break;
                }
                case 32: {
                    sb.append("Node moved");
                    String from = this.info.containsKey(JcrObservationManager.MOVE_FROM_KEY) ? this.info.get(JcrObservationManager.MOVE_FROM_KEY) : this.info.get(JcrObservationManager.ORDER_DEST_KEY);
                    String to = this.info.containsKey(JcrObservationManager.MOVE_TO_KEY) ? this.info.get(JcrObservationManager.MOVE_TO_KEY) : this.info.get(JcrObservationManager.ORDER_SRC_KEY);
                    sb.append(" from ").append(from).append(" to ").append(to).append(" by ").append(this.getUserID());
                    return sb.toString();
                }
            }
            sb.append(" at ").append(this.path).append(" by ").append(this.getUserID());
            return sb.toString();
        }
    }

    @Immutable
    class JcrEventBundle {
        private final DateTime date;
        private final String userId;
        private final String userData;

        public JcrEventBundle(DateTime dateTime, String userId, String userData) {
            this.userId = userId;
            this.userData = userData;
            this.date = dateTime;
        }

        public String getUserID() {
            return this.userId;
        }

        public DateTime getDate() {
            return this.date;
        }

        public String getUserData() {
            return this.userData;
        }
    }

    class JcrEventIterator
    extends JcrRangeIterator<Event>
    implements EventIterator {
        public JcrEventIterator(Collection<Event> events) {
            super(events);
        }

        public Event nextEvent() {
            return (Event)this.next();
        }
    }

    class JcrEventListenerIterator
    extends JcrRangeIterator<EventListener>
    implements EventListenerIterator {
        public JcrEventListenerIterator(Collection<EventListener> listeners) {
            super(listeners);
        }

        public EventListener nextEventListener() {
            return (EventListener)this.next();
        }
    }

    class JcrRangeIterator<E>
    implements RangeIterator {
        private final List<? extends E> elements;
        private int position = 0;

        public JcrRangeIterator(Collection<? extends E> elements) {
            CheckArg.isNotNull(elements, (String)"elements");
            this.elements = new ArrayList<E>(elements);
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.elements.size();
        }

        public boolean hasNext() {
            return this.getPosition() < this.getSize();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            E element = this.elements.get(this.position);
            ++this.position;
            return element;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void skip(long skipNum) {
            this.position = (int)((long)this.position + skipNum);
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
        }
    }
}

