/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;

class SystemContentInitializer
implements RepositoryCache.ContentInitializer {
    private PropertyFactory propFactory;

    @Override
    public void initialize(SessionCache session, MutableCachedNode parent) {
        this.propFactory = session.getContext().getPropertyFactory();
        MutableCachedNode system = null;
        MutableCachedNode namespaces = null;
        system = this.createNode(session, parent, "jcr:system", JcrLexicon.SYSTEM, ModeShapeLexicon.SYSTEM, new Property[0]);
        this.createNode(session, system, "jcr:nodeTypes", JcrLexicon.NODE_TYPES, ModeShapeLexicon.NODE_TYPES, new Property[0]);
        this.createNode(session, system, "jcr:versionStorage", JcrLexicon.VERSION_STORAGE, ModeShapeLexicon.VERSION_STORAGE, new Property[0]);
        namespaces = this.createNode(session, system, "mode:namespaces", ModeShapeLexicon.NAMESPACES, ModeShapeLexicon.NAMESPACES, new Property[0]);
        this.createNamespace(session, namespaces, "", "");
        this.createNamespace(session, namespaces, "jcr", "http://www.jcp.org/jcr/1.0");
        this.createNamespace(session, namespaces, "nt", "http://www.jcp.org/jcr/nt/1.0");
        this.createNamespace(session, namespaces, "mix", "http://www.jcp.org/jcr/mix/1.0");
        this.createNamespace(session, namespaces, "sv", "http://www.jcp.org/jcr/sv/1.0");
        this.createNamespace(session, namespaces, "mode", "http://www.modeshape.org/1.0");
        this.createNode(session, system, "mode:locks", ModeShapeLexicon.LOCKS, ModeShapeLexicon.LOCKS, new Property[0]);
    }

    protected MutableCachedNode createNode(SessionCache session, MutableCachedNode parent, String id, Name name, Name primaryType, Property ... properties) {
        NodeKey key = session.getRootKey().withId(id);
        return parent.createChild(session, key, name, this.propFactory.create(JcrLexicon.PRIMARY_TYPE, primaryType), properties);
    }

    protected MutableCachedNode createNamespace(SessionCache session, MutableCachedNode parent, String prefix, String uri) {
        Name nodeName = prefix.length() != 0 ? (Name)session.getContext().getValueFactories().getNameFactory().create(prefix) : ModeShapeLexicon.NAMESPACE;
        return this.createNode(session, parent, "mode:namespaces-" + uri, nodeName, ModeShapeLexicon.NAMESPACE, this.propFactory.create(ModeShapeLexicon.URI, uri), this.propFactory.create(ModeShapeLexicon.GENERATED, Boolean.FALSE));
    }
}

