/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.util.HashSet;
import org.modeshape.common.util.Logger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.cache.change.BinaryValueUnused;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;

public class UnusedBinaryChangeSetListener
implements ChangeSetListener {
    private final BinaryStore store;
    private final Logger logger;

    public UnusedBinaryChangeSetListener(BinaryStore store) {
        this.store = store;
        assert (this.store != null);
        this.logger = Logger.getLogger(this.getClass());
    }

    @Override
    public void notify(ChangeSet changeSet) {
        HashSet<BinaryKey> unusedKeys = null;
        for (Change change : changeSet) {
            if (!(change instanceof BinaryValueUnused)) continue;
            BinaryValueUnused unused = (BinaryValueUnused)change;
            if (unusedKeys == null) {
                unusedKeys = new HashSet<BinaryKey>();
            }
            unusedKeys.add(unused.getKey());
        }
        if (unusedKeys != null && !unusedKeys.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Marking binary values as unused: ", new Object[]{unusedKeys});
            }
            try {
                this.store.markAsUnused((Iterable<BinaryKey>)unusedKeys);
            }
            catch (BinaryStoreException e) {
                this.logger.error(JcrI18n.errorMarkingBinaryValuesUnused, new Object[]{e.getMessage()});
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Finished marking binary values as unused: ", new Object[]{unusedKeys});
            }
        }
    }
}

