/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrContentHandler;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLockManager;
import org.modeshape.jcr.JcrNamespaceRegistry;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrObservationManager;
import org.modeshape.jcr.JcrQueryManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrRepositoryMonitor;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrVersionManager;
import org.modeshape.jcr.api.Workspace;
import org.modeshape.jcr.api.monitor.RepositoryMonitor;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.ValueFormatException;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@ThreadSafe
class JcrWorkspace
implements Workspace {
    private final JcrSession session;
    private final String workspaceName;
    private final Lock lock = new ReentrantLock();
    private JcrNodeTypeManager nodeTypeManager;
    private JcrLockManager lockManager;
    private JcrNamespaceRegistry workspaceRegistry;
    private JcrVersionManager versionManager;
    private JcrQueryManager queryManager;
    private JcrRepositoryMonitor monitor;
    private JcrObservationManager observationManager;

    JcrWorkspace(JcrSession session, String workspaceName) {
        this.session = session;
        this.workspaceName = workspaceName;
    }

    final JcrRepository repository() {
        return this.session.repository();
    }

    final ExecutionContext context() {
        return this.session.context();
    }

    public final JcrSession getSession() {
        return this.session;
    }

    public final String getName() {
        return this.workspaceName;
    }

    public void copy(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.session.checkLive();
        CheckArg.isNotEmpty((String)srcAbsPath, (String)"srcAbsPath");
        CheckArg.isNotEmpty((String)destAbsPath, (String)"destAbsPath");
    }

    public void copy(String srcWorkspace, String srcAbsPath, String destAbsPath) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.session.checkLive();
        CheckArg.isNotEmpty((String)srcWorkspace, (String)"srcWorkspace");
        CheckArg.isNotEmpty((String)srcAbsPath, (String)"srcAbsPath");
        CheckArg.isNotEmpty((String)destAbsPath, (String)"destAbsPath");
    }

    public void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.session.checkLive();
        CheckArg.isNotEmpty((String)srcWorkspace, (String)"srcWorkspace");
        CheckArg.isNotEmpty((String)srcAbsPath, (String)"srcAbsPath");
        CheckArg.isNotEmpty((String)destAbsPath, (String)"destAbsPath");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.session.checkLive();
        CheckArg.isNotEmpty((String)srcAbsPath, (String)"srcAbsPath");
        CheckArg.isNotEmpty((String)destAbsPath, (String)"destAbsPath");
        JcrSession session = this.session.spawnSession(false);
        try {
            session.move(srcAbsPath, destAbsPath);
            session.save();
        }
        finally {
            session.logout();
        }
    }

    public void restore(Version[] versions, boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        this.session.checkLive();
    }

    public JcrLockManager getLockManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkLive();
        return this.lockManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JcrLockManager lockManager() {
        if (this.lockManager == null) {
            try {
                this.lock.lock();
                if (this.lockManager == null) {
                    this.lockManager = new JcrLockManager(this.session, this.repository().lockManager());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryManager getQueryManager() throws RepositoryException {
        this.session.checkLive();
        if (this.queryManager == null) {
            try {
                this.lock.lock();
                if (this.queryManager == null) {
                    this.queryManager = new JcrQueryManager(this.session);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.queryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        this.session.checkLive();
        if (this.workspaceRegistry == null) {
            try {
                this.lock.lock();
                if (this.workspaceRegistry == null) {
                    this.workspaceRegistry = new JcrNamespaceRegistry(this.repository().persistentRegistry(), this.session);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.workspaceRegistry;
    }

    public JcrNodeTypeManager getNodeTypeManager() throws RepositoryException {
        this.session.checkLive();
        return this.nodeTypeManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JcrNodeTypeManager nodeTypeManager() {
        if (this.nodeTypeManager == null) {
            try {
                this.lock.lock();
                if (this.nodeTypeManager == null) {
                    this.nodeTypeManager = new JcrNodeTypeManager(this.session, this.repository().nodeTypeManager());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.nodeTypeManager;
    }

    public ObservationManager getObservationManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkLive();
        return this.observationManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JcrObservationManager observationManager() {
        if (this.observationManager == null) {
            try {
                this.lock.lock();
                if (this.observationManager == null) {
                    this.observationManager = new JcrObservationManager(this.session, this.repository().repositoryCache(), this.repository().getRepositoryStatistics());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.observationManager;
    }

    public JcrVersionManager getVersionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkLive();
        return this.versionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JcrVersionManager versionManager() {
        if (this.versionManager == null) {
            try {
                this.lock.lock();
                if (this.versionManager == null) {
                    this.versionManager = new JcrVersionManager(this.session);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.versionManager;
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, AccessDeniedException, RepositoryException {
        CheckArg.isNotNull((Object)parentAbsPath, (String)"parentAbsPath");
        this.session.checkLive();
        JcrSession session = this.session.spawnSession(false);
        boolean saveWhenFinished = true;
        AbstractJcrNode parent = session.getNode(parentAbsPath);
        if (!parent.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{parent.getPath()}));
        }
        JcrRepository repo = this.getSession().getRepository();
        boolean retainLifecycleInfo = repo.getDescriptorValue("option.lifecycle.supported").getBoolean();
        boolean retainRetentionInfo = repo.getDescriptorValue("option.retention.supported").getBoolean();
        return new JcrContentHandler(session, parent, uuidBehavior, saveWhenFinished, retainRetentionInfo, retainLifecycleInfo);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, VersionException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, LockException, AccessDeniedException, RepositoryException {
        CheckArg.isNotNull((Object)parentAbsPath, (String)"parentAbsPath");
        CheckArg.isNotNull((Object)in, (String)"in");
        this.session.checkLive();
        boolean error = false;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(this.getImportContentHandler(parentAbsPath, uuidBehavior));
            parser.parse(new InputSource(in));
        }
        catch (JcrContentHandler.EnclosingSAXException ese) {
            Exception cause = ese.getException();
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)((Object)cause);
            }
            throw new RepositoryException((Throwable)cause);
        }
        catch (SAXParseException se) {
            error = true;
            throw new InvalidSerializedDataException((Throwable)se);
        }
        catch (SAXException se) {
            error = true;
            throw new RepositoryException((Throwable)se);
        }
        finally {
            block16: {
                try {
                    in.close();
                }
                catch (IOException t) {
                    if (!error) {
                        throw t;
                    }
                }
                catch (RuntimeException re) {
                    if (error) break block16;
                    throw re;
                }
            }
        }
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        this.session.checkLive();
        HashSet<String> names = new HashSet<String>(this.session.repository().repositoryCache().getWorkspaceNames());
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            try {
                this.session.checkPermission((String)iter.next(), null, "read");
            }
            catch (AccessDeniedException ace) {
                iter.remove();
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public void createWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkLive();
        try {
            JcrRepository repository = this.session.repository();
            repository.repositoryCache().createWorkspace(name);
            repository.statistics().increment(ValueMetric.WORKSPACE_COUNT);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedRepositoryOperationException(e.getMessage());
        }
    }

    public void createWorkspace(String name, String srcWorkspace) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        this.session.checkLive();
        this.createWorkspace(name);
    }

    public void deleteWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        this.session.checkLive();
        try {
            JcrRepository repository = this.session.repository();
            if (!repository.repositoryCache().destroyWorkspace(name)) {
                throw new NoSuchWorkspaceException(JcrI18n.workspaceNotFound.text(new Object[]{name, this.getName()}));
            }
            repository.statistics().decrement(ValueMetric.WORKSPACE_COUNT);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedRepositoryOperationException(e.getMessage());
        }
    }

    public void reindex() throws RepositoryException {
        this.session.checkPermission(this.workspaceName, Path.ROOT_PATH, "index_workspace");
        this.repository().runningState().queryManager().reindexContent(this);
    }

    public void reindex(String pathStr) throws RepositoryException {
        try {
            Path path = (Path)this.session.pathFactory().create(pathStr);
            this.session.checkPermission(this.workspaceName, path, "index_workspace");
            this.repository().runningState().queryManager().reindexContent(this, path, Integer.MAX_VALUE);
        }
        catch (ValueFormatException e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    public Future<Boolean> reindexAsync() throws RepositoryException {
        this.session.checkPermission(this.workspaceName, Path.ROOT_PATH, "index_workspace");
        return this.repository().runningState().queryManager().reindexContentAsync(this);
    }

    public Future<Boolean> reindexAsync(String pathStr) throws RepositoryException {
        try {
            Path path = (Path)this.session.pathFactory().create(pathStr);
            this.session.checkPermission(this.workspaceName, path, "index_workspace");
            return this.repository().runningState().queryManager().reindexContentAsync(this, path, Integer.MAX_VALUE);
        }
        catch (ValueFormatException e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryMonitor getRepositoryMonitor() throws RepositoryException {
        if (this.monitor == null) {
            try {
                this.lock.lock();
                if (this.monitor == null) {
                    this.monitor = new JcrRepositoryMonitor(this.session);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.monitor;
    }
}

