/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.jcr.value.Binary;

@NotThreadSafe
class SelfClosingInputStream
extends InputStream {
    private final Binary binary;
    private InputStream stream;

    public SelfClosingInputStream(Binary binary) {
        assert (binary != null);
        this.binary = binary;
    }

    protected void open() throws RepositoryException {
        if (this.stream == null) {
            this.stream = this.binary.getStream();
        }
    }

    @Override
    public int available() throws IOException {
        try {
            this.open();
            return this.stream.available();
        }
        catch (RepositoryException e) {
            this.binary.dispose();
            throw new IOException(e);
        }
        catch (IOException e) {
            this.binary.dispose();
            throw e;
        }
        catch (RuntimeException e) {
            this.binary.dispose();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            finally {
                this.binary.dispose();
            }
        }
    }

    public boolean equals(Object obj) {
        return this.binary.equals(obj);
    }

    public int hashCode() {
        return this.binary.hashCode();
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.open();
            this.stream.mark(readlimit);
        }
        catch (RepositoryException e) {
            this.binary.dispose();
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            this.binary.dispose();
            throw e;
        }
    }

    @Override
    public boolean markSupported() {
        try {
            this.open();
            return this.stream.markSupported();
        }
        catch (RepositoryException e) {
            this.binary.dispose();
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            this.binary.dispose();
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            this.open();
            int result = this.stream.read(b, off, len);
            if (result == -1) {
                this.binary.dispose();
            }
            return result;
        }
        catch (RepositoryException e) {
            this.binary.dispose();
            throw new IOException(e);
        }
        catch (IOException e) {
            this.binary.dispose();
            throw e;
        }
        catch (RuntimeException e) {
            this.binary.dispose();
            throw e;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            this.open();
            int result = this.stream.read(b);
            if (result == -1) {
                this.binary.dispose();
            }
            return result;
        }
        catch (RepositoryException e) {
            this.binary.dispose();
            throw new IOException(e);
        }
        catch (IOException e) {
            this.binary.dispose();
            throw e;
        }
        catch (RuntimeException e) {
            this.binary.dispose();
            throw e;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            this.open();
            int result = this.stream.read();
            if (result == -1) {
                this.binary.dispose();
            }
            return result;
        }
        catch (RepositoryException e) {
            this.binary.dispose();
            throw new IOException(e);
        }
        catch (IOException e) {
            this.binary.dispose();
            throw e;
        }
        catch (RuntimeException e) {
            this.binary.dispose();
            throw e;
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.stream != null) {
            try {
                this.stream.reset();
            }
            catch (IOException e) {
                this.binary.dispose();
                throw e;
            }
            catch (RuntimeException e) {
                this.binary.dispose();
                throw e;
            }
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            this.open();
            return this.stream.skip(n);
        }
        catch (RepositoryException e) {
            this.binary.dispose();
            throw new IOException(e);
        }
        catch (IOException e) {
            this.binary.dispose();
            throw e;
        }
        catch (RuntimeException e) {
            this.binary.dispose();
            throw e;
        }
    }

    public String toString() {
        return this.binary.toString();
    }
}

