/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;

public class NotQuery
extends Query {
    private static final long serialVersionUID = 1L;
    protected final Query operand;

    public NotQuery(Query operand) {
        this.operand = operand;
    }

    public Weight createWeight(Searcher searcher) {
        return new NotWeight(searcher);
    }

    public Object clone() {
        return new NotQuery(this.operand);
    }

    public String toString(String field) {
        return "NOT(" + this.operand.toString(field) + ")";
    }

    protected static class NotScorer
    extends Scorer {
        private int docId = -1;
        private int nextScoredDocId = -1;
        private final Scorer operandScorer;
        private final IndexReader reader;
        private final int pastMaxDocId;

        protected NotScorer(Scorer operandScorer, IndexReader reader, Weight weight) {
            super(weight);
            this.operandScorer = operandScorer;
            this.reader = reader;
            assert (this.operandScorer != null);
            assert (this.reader != null);
            this.pastMaxDocId = this.reader.maxDoc();
        }

        public int docID() {
            return this.docId;
        }

        public int nextDoc() throws IOException {
            if (this.nextScoredDocId == -1) {
                this.nextScoredDocId = this.operandScorer.nextDoc();
            }
            while (true) {
                ++this.docId;
                if (this.docId == this.pastMaxDocId) {
                    return Integer.MAX_VALUE;
                }
                if (this.docId == this.nextScoredDocId) {
                    this.nextScoredDocId = this.operandScorer.nextDoc();
                    continue;
                }
                if (!this.reader.isDeleted(this.docId)) break;
            }
            return this.docId;
        }

        public int advance(int target) throws IOException {
            int doc;
            if (target == Integer.MAX_VALUE) {
                return target;
            }
            while ((doc = this.nextDoc()) < target) {
            }
            return doc;
        }

        public float score() {
            return 1.0f;
        }
    }

    protected class NotWeight
    extends Weight {
        private static final long serialVersionUID = 1L;
        private final Searcher searcher;

        protected NotWeight(Searcher searcher) {
            this.searcher = searcher;
            assert (this.searcher != null);
        }

        public Query getQuery() {
            return NotQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer operandScorer = NotQuery.this.operand.weight(this.searcher).scorer(reader, scoreDocsInOrder, topScorer);
            if (operandScorer == null) {
                return null;
            }
            return new NotScorer(operandScorer, reader, this);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation operandExplanation = NotQuery.this.operand.weight(this.searcher).explain(reader, doc);
            String desc = operandExplanation.getDescription();
            return new Explanation(this.getValue(), "NOT(" + desc + ")");
        }
    }
}

