/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.jcr.query.model.LanguageObject;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.Visitor;
import org.modeshape.jcr.query.model.Visitors;

@Immutable
public class Column
implements LanguageObject,
javax.jcr.query.qom.Column {
    private static final long serialVersionUID = 1L;
    private final SelectorName selectorName;
    private final String propertyName;
    private final String columnName;

    public Column(SelectorName selectorName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        this.selectorName = selectorName;
        this.propertyName = null;
        this.columnName = null;
    }

    public Column(SelectorName selectorName, String propertyName, String columnName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        CheckArg.isNotNull((Object)columnName, (String)"columnName");
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.columnName = columnName;
    }

    public final SelectorName selectorName() {
        return this.selectorName;
    }

    public String getSelectorName() {
        return this.selectorName.getString();
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.selectorName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Column) {
            Column that = (Column)obj;
            if (!this.selectorName.equals(that.selectorName)) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls((Object)this.propertyName, (Object)that.propertyName)) {
                return false;
            }
            return ObjectUtil.isEqualWithNulls((Object)this.columnName, (Object)that.columnName);
        }
        return false;
    }

    public Column with(SelectorName newSelectorName) {
        return new Column(newSelectorName, this.propertyName, this.columnName);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

