/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.parse;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.query.JcrTypeSystem;
import org.modeshape.jcr.query.model.LiteralValue;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.query.parse.BasicSqlQueryParser;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.ValueFormatException;

public class JcrSql2QueryParser
extends BasicSqlQueryParser {
    public static final String LANGUAGE = "JCR-SQL2";

    @Override
    public String getLanguage() {
        return LANGUAGE;
    }

    @Override
    protected LiteralValue literal(TypeSystem typeSystem, Object value) throws ValueFormatException {
        ValueFactory factory = ((JcrTypeSystem)typeSystem).getValueFactory();
        Value jcrValue = null;
        if (value instanceof String) {
            jcrValue = factory.createValue((String)value);
        } else if (value instanceof Boolean) {
            jcrValue = factory.createValue(((Boolean)value).booleanValue());
        } else if (value instanceof Binary) {
            jcrValue = factory.createValue((Binary)value);
        } else if (value instanceof DateTime) {
            jcrValue = factory.createValue(((DateTime)value).toCalendar());
        } else if (value instanceof Calendar) {
            jcrValue = factory.createValue((Calendar)value);
        } else if (value instanceof BigDecimal) {
            jcrValue = factory.createValue((BigDecimal)value);
        } else if (value instanceof Double) {
            jcrValue = factory.createValue(((Double)value).doubleValue());
        } else if (value instanceof Long) {
            jcrValue = factory.createValue(((Long)value).longValue());
        } else if (value instanceof InputStream) {
            try {
                Binary binary = factory.createBinary((InputStream)value);
                jcrValue = factory.createValue(binary);
            }
            catch (RepositoryException e) {
                throw new ValueFormatException(value, PropertyType.BINARY, e.getMessage());
            }
        } else if (value instanceof Node) {
            try {
                jcrValue = factory.createValue((Node)value);
            }
            catch (RepositoryException e) {
                throw new ValueFormatException(value, PropertyType.REFERENCE, e.getMessage());
            }
        } else {
            jcrValue = factory.createValue(value.toString());
        }
        return new LiteralValue(jcrValue, value);
    }
}

