/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.JndiRepositoryFactory;
import org.modeshape.jcr.api.NamedRepository;
import org.modeshape.jcr.api.Repositories;
import org.modeshape.jcr.api.RepositoryFactory;
import org.modeshape.jcr.api.ServletCredentials;
import org.modeshape.web.jcr.NoSuchRepositoryException;

@ThreadSafe
public class RepositoryManager {
    private static final Map<String, Object> factoryParams = new HashMap<String, Object>();
    private static final Map<String, Object> immutableFactoryParams = Collections.unmodifiableMap(factoryParams);

    private RepositoryManager() {
    }

    static synchronized void initialize(ServletContext context) {
        CheckArg.isNotNull((Object)context, (String)"context");
        factoryParams.clear();
        Enumeration names = context.getInitParameterNames();
        if (names == null) {
            RepositoryManager.addParameter(factoryParams, "org.modeshape.jcr.URL", context);
            RepositoryManager.addParameter(factoryParams, "org.modeshape.jcr.RepositoryName", context);
        } else {
            while (names.hasMoreElements()) {
                Object next = names.nextElement();
                if (next == null) continue;
                String name = next.toString();
                RepositoryManager.addParameter(factoryParams, name, context);
            }
        }
    }

    private static final void addParameter(Map<String, Object> params, String name, ServletContext context) {
        String value = context.getInitParameter(name);
        if (value != null) {
            factoryParams.put(name, value);
        }
    }

    public static Session getSession(HttpServletRequest request, String repositoryName, String workspaceName) throws RepositoryException {
        Repository repository = null;
        boolean found = false;
        for (javax.jcr.RepositoryFactory factory : ServiceLoader.load(javax.jcr.RepositoryFactory.class)) {
            found = true;
            if (factory instanceof Repositories) {
                Repositories repositories = (Repositories)factory;
                try {
                    repository = repositories.getRepository(repositoryName);
                    break;
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
            }
            try {
                HashMap<String, Object> params = new HashMap<String, Object>(immutableFactoryParams);
                params.put("org.modeshape.jcr.RepositoryName", repositoryName);
                repository = factory.getRepository(params);
                if (repository == null) continue;
                break;
            }
            catch (RepositoryException e) {
            }
        }
        if (!found) {
            throw new IllegalStateException("No javax.jcr.RepositoryFactory implementation on the classpath");
        }
        if (repository == null) {
            throw new NoSuchRepositoryException("No repository named '" + repositoryName + "' was found");
        }
        if (request == null || request.getUserPrincipal() == null) {
            return repository.login(workspaceName);
        }
        return repository.login((Credentials)new ServletCredentials(request), workspaceName);
    }

    public static Set<String> getJcrRepositoryNames() {
        HashSet<String> names = new HashSet<String>();
        boolean found = false;
        for (javax.jcr.RepositoryFactory factory : ServiceLoader.load(javax.jcr.RepositoryFactory.class)) {
            found = true;
            if (factory instanceof Repositories) {
                Repositories repositories = (Repositories)factory;
                Set someNames = repositories.getRepositoryNames();
                if (someNames.isEmpty()) {
                    try {
                        Repository repository = factory.getRepository(immutableFactoryParams);
                        if (repository instanceof NamedRepository) {
                            String name = ((NamedRepository)repository).getName();
                            names.add(name);
                        }
                    }
                    catch (RepositoryException e) {
                        // empty catch block
                    }
                }
                names.addAll(repositories.getRepositoryNames());
                continue;
            }
            if (factory instanceof JndiRepositoryFactory) {
                JndiRepositoryFactory jndiFactory = (JndiRepositoryFactory)factory;
                try {
                    names.addAll(jndiFactory.getRepositoryNames(immutableFactoryParams));
                }
                catch (RepositoryException e) {}
                continue;
            }
            try {
                Repository repository = factory.getRepository(immutableFactoryParams);
                if (!(repository instanceof NamedRepository)) continue;
                String name = ((NamedRepository)repository).getName();
                names.add(name);
            }
            catch (RepositoryException e) {}
        }
        if (!found) {
            throw new IllegalStateException("No RepositoryFactory implementation on the classpath");
        }
        return names;
    }

    static void shutdown() {
        for (javax.jcr.RepositoryFactory factory : ServiceLoader.load(javax.jcr.RepositoryFactory.class)) {
            if (!(factory instanceof RepositoryFactory)) continue;
            RepositoryFactory modeShapeFactory = (RepositoryFactory)factory;
            modeShapeFactory.shutdown();
        }
    }
}

