/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.common.naming.SingletonInitialContextFactory;
import org.modeshape.jboss.lifecycle.JBossLifeCycleListener;
import org.modeshape.jboss.service.EngineService;
import org.modeshape.jboss.service.ReferenceFactoryService;
import org.modeshape.jboss.subsystem.Element;
import org.modeshape.jboss.subsystem.JBossSubsystemI18n;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.RepositoryAdd;
import org.modeshape.jcr.JcrEngine;

class ModeShapeAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    private static Element[] attributes = new Element[0];
    EngineService engine;
    SingletonInitialContextFactory scf = new SingletonInitialContextFactory();
    final JBossLifeCycleListener shutdownListener = new JBossLifeCycleListener();

    ModeShapeAdd() {
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle bundle = JBossSubsystemI18n.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("modeshape.add"));
        ModeShapeAdd.describeModeShape(node, "request-properties", bundle);
        return node;
    }

    static void describeModeShape(ModelNode node, String type, ResourceBundle bundle) {
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i].describe(node, type, bundle);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ModeShapeAdd.populate(operation, model);
    }

    static void populate(ModelNode operation, ModelNode model) {
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i].populate(operation, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)Module.getCallerModule().getClassLoader());
            this.initializeModeShapeEngine(context, operation, newControllers);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classloader);
        }
    }

    private void initializeModeShapeEngine(OperationContext context, ModelNode operation, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceTarget target = context.getServiceTarget();
        JBossLifeCycleListener shutdownListener = new JBossLifeCycleListener();
        this.engine = this.buildModeShapeEngine(operation);
        ServiceBuilder engineBuilder = target.addService(ModeShapeServiceNames.ENGINE, (Service)this.engine);
        engineBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController controller = engineBuilder.install();
        controller.getServiceContainer().addTerminateListener((ServiceContainer.TerminateListener)shutdownListener);
        newControllers.add(controller);
        ReferenceFactoryService referenceFactoryService = new ReferenceFactoryService();
        ServiceName referenceFactoryServiceName = ModeShapeServiceNames.ENGINE.append(new String[]{"reference-factory"});
        ServiceBuilder referenceBuilder = target.addService(referenceFactoryServiceName, referenceFactoryService);
        referenceBuilder.addDependency(ModeShapeServiceNames.ENGINE, JcrEngine.class, referenceFactoryService.getInjector());
        referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)RepositoryAdd.jndiBaseName);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binderService);
        binderBuilder.addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, binderService.getManagedObjectInjector());
        binderBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(referenceBuilder.install());
        newControllers.add(binderBuilder.install());
    }

    private EngineService buildModeShapeEngine(ModelNode node) {
        EngineService engine = new EngineService(new JcrEngine());
        return engine;
    }
}

