/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Json;
import org.infinispan.schematic.document.ParsingException;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.RepositoryService;
import org.modeshape.jboss.subsystem.Element;
import org.modeshape.jboss.subsystem.JBossSubsystemI18n;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.RepositoryConfiguration;

public class RepositoryAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    private static Element[] attributes = new Element[]{Element.REPOSITORY_NAME_ATTRIBUTE, Element.REPOSITORY_JNDI_NAME_ATTRIBUTE, Element.SEQUENCER_NAME_ATTRIBUTE, Element.SEQUENCER_DESCRIPTION_ATTRIBUTE, Element.SEQUENCER_TYPE_ATTRIBUTE, Element.SEQUENCER_EXPRESSIONS_ATTRIBUTE};
    public static String jndiBaseName = "jcr/local/";
    public static final RepositoryAdd INSTANCE = new RepositoryAdd();

    private RepositoryAdd() {
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle bundle = JBossSubsystemI18n.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set("repository.add");
        RepositoryAdd.describeRepository(node, "request-properties", bundle);
        return node;
    }

    static void describeRepository(ModelNode node, String type, ResourceBundle bundle) {
        RepositoryAdd.repositoryDescribe(node, type, bundle);
    }

    static void repositoryDescribe(ModelNode node, String type, ResourceBundle bundle) {
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i].describe(node, type, bundle);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        RepositoryAdd.populate(operation, model);
    }

    public static void populate(ModelNode operation, ModelNode model) {
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i].populate(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        Document configDoc;
        ServiceTarget target = context.getServiceTarget();
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String repositoryName = pathAddress.getLastElement().getValue();
        StringBuilder jndiName = new StringBuilder(jndiBaseName);
        if (Element.REPOSITORY_JNDI_NAME_ATTRIBUTE.isDefined(model)) {
            jndiName.append(Element.REPOSITORY_JNDI_NAME_ATTRIBUTE.asString(model));
        } else {
            jndiName.append(repositoryName);
        }
        ArrayList<String> expressionList = new ArrayList<String>();
        if (Element.SEQUENCER_EXPRESSIONS_ATTRIBUTE.isDefined(operation)) {
            String domains = Element.SEQUENCER_EXPRESSIONS_ATTRIBUTE.asString(operation);
            StringTokenizer st = new StringTokenizer(domains, ",");
            while (st.hasMoreTokens()) {
                expressionList.add(st.nextToken());
            }
        }
        String jsonString = model.toJSONString(true);
        try {
            configDoc = Json.read((String)jsonString);
        }
        catch (ParsingException e) {
            throw new OperationFailedException((Throwable)e, model);
        }
        RepositoryService repositoryService = new RepositoryService(new RepositoryConfiguration(configDoc, repositoryName));
        ServiceBuilder repositoryBuilder = target.addService(ModeShapeServiceNames.repositoryServiceName(repositoryName), (Service)repositoryService);
        repositoryBuilder.addDependency(ModeShapeServiceNames.ENGINE, JcrEngine.class, repositoryService.getJcrEngineInjector());
        repositoryBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController controller = repositoryBuilder.install();
        newControllers.add(controller);
    }
}

