/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.javafile;

import java.io.IOException;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.classfile.ClassFileSequencer;
import org.modeshape.sequencer.javafile.ClassSourceFileRecorder;
import org.modeshape.sequencer.javafile.JavaMetadataUtil;
import org.modeshape.sequencer.javafile.SourceFileRecorder;
import org.modeshape.sequencer.javafile.metadata.JavaMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFileSequencer
extends Sequencer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaFileSequencer.class);
    private static final SourceFileRecorder DEFAULT_SOURCE_FILE_RECORDER = new ClassSourceFileRecorder();
    private SourceFileRecorder sourceFileRecorder = DEFAULT_SOURCE_FILE_RECORDER;

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        String classFileCnd = "/" + ClassFileSequencer.class.getPackage().getName().replaceAll("\\.", "/") + "/sequencer-classfile.cnd";
        this.registerNodeTypes(classFileCnd, nodeTypeManager, true);
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        try {
            JavaMetadata javaMetadata = JavaMetadata.instance(binaryValue.getStream(), JavaMetadataUtil.length(binaryValue.getStream()), null);
            this.sourceFileRecorder.record(context, outputNode, javaMetadata);
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("Error sequencing file", (Throwable)ex);
            return false;
        }
    }

    public void setSourceFileRecorderClassName(String sourceFileRecorderClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (sourceFileRecorderClassName == null) {
            this.sourceFileRecorder = DEFAULT_SOURCE_FILE_RECORDER;
            return;
        }
        Class<?> sourceFileRecorderClass = Class.forName(sourceFileRecorderClassName);
        this.sourceFileRecorder = (SourceFileRecorder)sourceFileRecorderClass.newInstance();
    }
}

