/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.schematic.document.Immutable;
import org.infinispan.schematic.document.Path;
import org.infinispan.util.Util;

public class Paths {
    protected static final Path EMPTY_PATH = new EmptyPath();

    protected static final void notNull(Object value, String name) {
        if (value == null) {
            throw new IllegalArgumentException("The '" + name + "' argument may not be null");
        }
    }

    protected static final String notNull(String value, String name) {
        if (value == null) {
            throw new IllegalArgumentException("The '" + name + "' argument may not be null");
        }
        value = value.trim();
        return value;
    }

    public static Path rootPath() {
        return EMPTY_PATH;
    }

    public static Path path(String fieldName) {
        return new SinglePath(Paths.notNull(fieldName, "fieldName"));
    }

    public static Path path(String ... fieldNames) {
        Paths.notNull(fieldNames, "fieldNames");
        switch (fieldNames.length) {
            case 0: {
                return EMPTY_PATH;
            }
            case 1: {
                return new SinglePath(fieldNames[0]);
            }
        }
        return new MultiSegmentPath(Arrays.asList(fieldNames));
    }

    public static Path path(List<String> fieldNames) {
        Paths.notNull(fieldNames, "fieldNames");
        switch (fieldNames.size()) {
            case 0: {
                return EMPTY_PATH;
            }
            case 1: {
                return new SinglePath(fieldNames.get(0));
            }
        }
        return new MultiSegmentPath(new ArrayList<String>(fieldNames));
    }

    public static Path path(Path path, String fieldName) {
        Paths.notNull(path, "path");
        return path.with(Paths.notNull(fieldName, "fieldName"));
    }

    public static Path path(Path path, String ... fieldNames) {
        Paths.notNull(path, "path");
        Paths.notNull(fieldNames, "fieldNames");
        if (fieldNames.length == 0) {
            return path;
        }
        ArrayList<String> names = new ArrayList<String>(path.size() + fieldNames.length);
        int i = 0;
        for (String name : path) {
            names.add(Paths.notNull(name, "fieldNames[" + i++ + "]"));
        }
        for (String name : fieldNames) {
            names.add(Paths.notNull(name, "fieldNames[" + i++ + "]"));
        }
        return new MultiSegmentPath(names);
    }

    public static Path path(Path path, List<String> fieldNames) {
        Paths.notNull(path, "path");
        Paths.notNull(fieldNames, "fieldNames");
        if (fieldNames.isEmpty()) {
            return path;
        }
        ArrayList<String> names = new ArrayList<String>(path.size() + fieldNames.size());
        int i = 0;
        for (String name : path) {
            names.add(Paths.notNull(name, "fieldNames[" + i++ + "]"));
        }
        for (String name : fieldNames) {
            names.add(Paths.notNull(name, "fieldNames[" + i++ + "]"));
        }
        return new MultiSegmentPath(names);
    }

    public static class Externalizer
    extends AbstractExternalizer<Path> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, Path path) throws IOException {
            output.write(path.size());
            for (String fieldName : path) {
                output.writeUTF(fieldName);
            }
        }

        public Path readObject(ObjectInput input) throws IOException {
            int number = input.readInt();
            if (number == 0) {
                return Paths.rootPath();
            }
            if (number == 1) {
                String fieldName = input.readUTF();
                return Paths.path(fieldName);
            }
            ArrayList<String> fieldNames = new ArrayList<String>(number);
            for (int i = 0; i != number; ++i) {
                fieldNames.add(input.readUTF());
            }
            return Paths.path(fieldNames);
        }

        public Integer getId() {
            return 1613;
        }

        public Set<Class<? extends Path>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{EmptyPath.class, SinglePath.class, MultiSegmentPath.class});
        }
    }

    @Immutable
    protected static final class MultiSegmentPath
    implements Path {
        private final List<String> fieldNames;
        private transient String composite;

        protected MultiSegmentPath(List<String> fieldNames) {
            assert (fieldNames != null);
            assert (!fieldNames.isEmpty());
            this.fieldNames = fieldNames;
        }

        @Override
        public Iterator<String> iterator() {
            final Iterator<String> actualIter = this.fieldNames.iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return actualIter.hasNext();
                }

                @Override
                public String next() {
                    return (String)actualIter.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public String get(int index) {
            return this.fieldNames.get(index);
        }

        @Override
        public String getLast() {
            return this.fieldNames.get(this.fieldNames.size() - 1);
        }

        @Override
        public String getFirst() {
            return this.fieldNames.get(0);
        }

        @Override
        public int size() {
            return this.fieldNames.size();
        }

        @Override
        public boolean startsWith(Path other) {
            if (other.size() > this.size()) {
                return false;
            }
            Iterator thatIter = other.iterator();
            Iterator<String> thisIter = this.iterator();
            while (thatIter.hasNext() && thisIter.hasNext()) {
                if (thisIter.next().equals(thatIter.next())) continue;
                return false;
            }
            return !thatIter.hasNext();
        }

        @Override
        public Path with(String fieldName) {
            fieldName = Paths.notNull(fieldName, "fieldName");
            ArrayList<String> newFieldNames = new ArrayList<String>(this.fieldNames.size() + 1);
            newFieldNames.addAll(this.fieldNames);
            newFieldNames.add(fieldName);
            return new MultiSegmentPath(newFieldNames);
        }

        @Override
        public Path parent() {
            if (this.size() <= 1) {
                return EMPTY_PATH;
            }
            List<String> parentFieldNames = this.fieldNames.subList(0, this.fieldNames.size() - 1);
            return new MultiSegmentPath(parentFieldNames);
        }

        public int hashCode() {
            return ((Object)this.fieldNames).hashCode();
        }

        @Override
        public int compareTo(Path that) {
            if (that == this) {
                return 0;
            }
            int diff = this.size() - that.size();
            if (diff != 0) {
                return diff;
            }
            Iterator thatIter = that.iterator();
            Iterator<String> thisIter = this.iterator();
            while (thatIter.hasNext()) {
                int value = thisIter.next().compareTo((String)thatIter.next());
                if (value == 0) continue;
                return value;
            }
            assert (!thisIter.hasNext());
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Path) {
                Path that = (Path)obj;
                if (this.size() != that.size()) {
                    return false;
                }
                Iterator thatIter = that.iterator();
                Iterator<String> thisIter = this.iterator();
                while (thatIter.hasNext()) {
                    if (thisIter.next().equals(thatIter.next())) continue;
                    return false;
                }
                assert (!thisIter.hasNext());
                return true;
            }
            return false;
        }

        public String toString() {
            if (this.composite == null) {
                StringBuilder sb = new StringBuilder();
                Iterator<String> iter = this.fieldNames.iterator();
                if (iter.hasNext()) {
                    sb.append(iter.next());
                    while (iter.hasNext()) {
                        sb.append('.');
                        sb.append(iter.next());
                    }
                }
                this.composite = sb.toString();
            }
            return this.composite;
        }
    }

    @Immutable
    protected static final class SinglePath
    implements Path {
        private final String fieldName;

        protected SinglePath(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private boolean done = false;

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public String next() {
                    this.done = true;
                    return SinglePath.this.fieldName;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public String get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
            }
            return this.fieldName;
        }

        @Override
        public String getLast() {
            return this.fieldName;
        }

        @Override
        public String getFirst() {
            return this.fieldName;
        }

        @Override
        public Path with(String fieldName) {
            return Paths.path(this.fieldName, fieldName);
        }

        @Override
        public Path parent() {
            return EMPTY_PATH;
        }

        @Override
        public int size() {
            return 1;
        }

        public int hashCode() {
            return this.fieldName.hashCode();
        }

        @Override
        public int compareTo(Path that) {
            if (that == this) {
                return 0;
            }
            int diff = this.size() - that.size();
            if (diff != 0) {
                return diff;
            }
            return this.fieldName.compareTo(that.get(0));
        }

        @Override
        public boolean startsWith(Path ancestor) {
            return this.equals(ancestor);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SinglePath) {
                SinglePath that = (SinglePath)obj;
                return this.fieldName.equals(that.fieldName);
            }
            if (obj instanceof Path) {
                Path that = (Path)obj;
                if (this.size() != that.size()) {
                    return false;
                }
                return this.fieldName.equals(that.get(0));
            }
            return false;
        }

        public String toString() {
            return this.fieldName;
        }
    }

    @Immutable
    protected static final class EmptyPath
    implements Path {
        protected EmptyPath() {
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public String next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public String get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
        }

        @Override
        public String getLast() {
            return null;
        }

        @Override
        public String getFirst() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean startsWith(Path ancestor) {
            return ancestor.size() == 0;
        }

        @Override
        public Path with(String fieldName) {
            return fieldName != null ? new SinglePath(Paths.notNull(fieldName, "fieldName")) : this;
        }

        @Override
        public Path parent() {
            return EMPTY_PATH;
        }

        @Override
        public int compareTo(Path that) {
            if (that == this) {
                return 0;
            }
            if (that instanceof EmptyPath) {
                return 0;
            }
            return 0 - that.size();
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Path) {
                Path that = (Path)obj;
                return that.size() == 0;
            }
            return false;
        }

        public String toString() {
            return "";
        }
    }
}

