/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.Logger;
import org.modeshape.jcr.CndImporter;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrContentHandler;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeDefinitionTemplate;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeIterator;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.NodeTypeExistsException;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.XmlNodeTypeReader;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@Immutable
public class JcrNodeTypeManager
implements NodeTypeManager {
    private final JcrSession session;
    private final RepositoryNodeTypeManager repositoryTypeManager;
    private Schemata schemata;

    JcrNodeTypeManager(JcrSession session, RepositoryNodeTypeManager repositoryTypeManager) {
        this.session = session;
        this.repositoryTypeManager = repositoryTypeManager;
    }

    private final ExecutionContext context() {
        return this.session.context();
    }

    Schemata schemata() {
        if (this.schemata == null) {
            this.schemata = this.repositoryTypeManager.getRepositorySchemata().getSchemataForSession(this.session);
            assert (this.schemata != null);
        }
        return this.schemata;
    }

    void signalNamespaceChanges() {
        this.schemata = null;
    }

    final RepositoryNodeTypeManager.NodeTypes nodeTypes() {
        return this.repositoryTypeManager.getNodeTypes();
    }

    public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
        this.session.checkLive();
        return new JcrNodeTypeIterator(this.nodeTypes().getAllNodeTypes());
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        this.session.checkLive();
        Collection<JcrNodeType> rawTypes = this.nodeTypes().getMixinNodeTypes();
        ArrayList<JcrNodeType> types = new ArrayList<JcrNodeType>(rawTypes.size());
        for (JcrNodeType type : rawTypes) {
            types.add(type.with(this.context(), this.session));
        }
        return new JcrNodeTypeIterator(types);
    }

    public JcrNodeType getNodeType(String nodeTypeName) throws NoSuchNodeTypeException, RepositoryException {
        this.session.checkLive();
        Name ntName = (Name)this.context().getValueFactories().getNameFactory().create(nodeTypeName);
        JcrNodeType type = this.nodeTypes().getNodeType(ntName);
        if (type != null) {
            type = type.with(this.context(), this.session);
            return type;
        }
        throw new NoSuchNodeTypeException(JcrI18n.typeNotFound.text(new Object[]{nodeTypeName}));
    }

    JcrNodeType getNodeType(Name nodeTypeName) {
        JcrNodeType nodeType = this.nodeTypes().getNodeType(nodeTypeName);
        if (nodeType != null) {
            nodeType = nodeType.with(this.context(), this.session);
        }
        return nodeType;
    }

    public boolean hasNodeType(String nodeTypeName) {
        Name ntName = (Name)this.context().getValueFactories().getNameFactory().create(nodeTypeName);
        return this.nodeTypes().hasNodeType(ntName);
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        this.session.checkLive();
        Collection<JcrNodeType> rawTypes = this.nodeTypes().getPrimaryNodeTypes();
        ArrayList<JcrNodeType> types = new ArrayList<JcrNodeType>(rawTypes.size());
        for (JcrNodeType type : rawTypes) {
            types.add(type.with(this.context(), this.session));
        }
        return new JcrNodeTypeIterator(types);
    }

    JcrNodeDefinition getRootNodeDefinition() throws NoSuchNodeTypeException, RepositoryException {
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.nodeTypes();
        for (JcrNodeDefinition definition : nodeTypes.getNodeType(ModeShapeLexicon.ROOT).getChildNodeDefinitions()) {
            if (!definition.getName().equals("*")) continue;
            return definition;
        }
        assert (false);
        return null;
    }

    JcrNodeDefinition getNodeDefinition(NodeDefinitionId definitionId) {
        if (definitionId == null) {
            return null;
        }
        return this.nodeTypes().getChildNodeDefinition(definitionId);
    }

    JcrPropertyDefinition getPropertyDefinition(PropertyDefinitionId definitionId) {
        if (definitionId == null) {
            return null;
        }
        return this.nodeTypes().getPropertyDefinition(definitionId);
    }

    final JcrPropertyDefinition findPropertyDefinition(Name primaryTypeName, Collection<Name> mixinTypeNames, Name propertyName, Value value, boolean checkMultiValuedDefinitions, boolean skipProtected) {
        return this.nodeTypes().findPropertyDefinition(this.session, primaryTypeName, mixinTypeNames, propertyName, value, checkMultiValuedDefinitions, skipProtected);
    }

    final JcrPropertyDefinition findPropertyDefinition(Name primaryTypeName, Collection<Name> mixinTypeNames, Name propertyName, Value value, boolean checkMultiValuedDefinitions, boolean skipProtected, boolean checkTypesAndConstraints) {
        return this.nodeTypes().findPropertyDefinition(this.session, primaryTypeName, mixinTypeNames, propertyName, value, checkMultiValuedDefinitions, skipProtected, checkTypesAndConstraints);
    }

    final JcrPropertyDefinition findPropertyDefinition(Name primaryTypeName, Collection<Name> mixinTypeNames, Name propertyName, Value[] values, boolean skipProtected) {
        return this.nodeTypes().findPropertyDefinition(this.session, primaryTypeName, mixinTypeNames, propertyName, values, skipProtected);
    }

    final JcrPropertyDefinition findPropertyDefinition(Name primaryTypeName, Collection<Name> mixinTypeNames, Name propertyName, Value[] values, boolean skipProtected, boolean checkTypeAndConstraints) {
        return this.nodeTypes().findPropertyDefinition(this.session, primaryTypeName, mixinTypeNames, propertyName, values, skipProtected, checkTypeAndConstraints);
    }

    boolean canRemoveProperty(Name primaryTypeNameOfParent, List<Name> mixinTypeNamesOfParent, Name propertyName, boolean skipProtected) {
        return this.nodeTypes().canRemoveProperty(primaryTypeNameOfParent, mixinTypeNamesOfParent, propertyName, skipProtected);
    }

    final JcrNodeDefinition findChildNodeDefinition(Name primaryTypeNameOfParent, Collection<Name> mixinTypeNamesOfParent, Name childName, Name childPrimaryNodeType, int numberOfExistingChildrenWithSameName, boolean skipProtected) {
        return this.nodeTypes().findChildNodeDefinition(primaryTypeNameOfParent, mixinTypeNamesOfParent, childName, childPrimaryNodeType, numberOfExistingChildrenWithSameName, skipProtected);
    }

    final boolean canRemoveAllChildren(Name primaryTypeNameOfParent, Collection<Name> mixinTypeNamesOfParent, Name childName, boolean skipProtected) {
        return this.nodeTypes().canRemoveAllChildren(primaryTypeNameOfParent, mixinTypeNamesOfParent, childName, skipProtected);
    }

    public NodeType registerNodeType(NodeTypeDefinition template, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        this.session.checkLive();
        try {
            this.session.checkPermission((Path)null, "register_type");
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        return this.repositoryTypeManager.registerNodeType(template, !allowUpdate);
    }

    public NodeTypeIterator registerNodeTypes(Collection<NodeTypeDefinition> templates, boolean allowUpdates) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        this.session.checkLive();
        try {
            this.session.checkPermission((Path)null, "register_type");
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        return new JcrNodeTypeIterator(this.repositoryTypeManager.registerNodeTypes(templates, !allowUpdates, false, true));
    }

    public NodeTypeIterator registerNodeTypes(Iterable<NodeTypeDefinition> nodeTypes) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        try {
            this.session.checkPermission((Path)null, "register_type");
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        return new JcrNodeTypeIterator(this.repositoryTypeManager.registerNodeTypes(nodeTypes));
    }

    public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] ntds, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        try {
            this.session.checkPermission((Path)null, "register_type");
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        return new JcrNodeTypeIterator(this.repositoryTypeManager.registerNodeTypes(Arrays.asList(ntds), !allowUpdate, false, true));
    }

    public void unregisterNodeType(String nodeTypeName) throws NoSuchNodeTypeException, InvalidNodeTypeDefinitionException, RepositoryException {
        this.unregisterNodeTypes(Collections.singleton(nodeTypeName));
    }

    public void unregisterNodeTypes(Collection<String> nodeTypeNames) throws NoSuchNodeTypeException, InvalidNodeTypeDefinitionException, RepositoryException {
        NameFactory nameFactory = this.context().getValueFactories().getNameFactory();
        try {
            this.session.checkPermission((Path)null, "register_type");
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        ArrayList<Name> names = new ArrayList<Name>(nodeTypeNames.size());
        for (String name : nodeTypeNames) {
            names.add((Name)nameFactory.create(name));
        }
        boolean failIfNodeTypesAreUsed = true;
        this.repositoryTypeManager.unregisterNodeType(names, failIfNodeTypesAreUsed);
    }

    public void unregisterNodeTypes(String[] names) throws NoSuchNodeTypeException, RepositoryException {
        this.unregisterNodeTypes(Arrays.asList(names));
    }

    public NodeTypeTemplate createNodeTypeTemplate() throws RepositoryException {
        return new JcrNodeTypeTemplate(this.context());
    }

    public NodeTypeTemplate createNodeTypeTemplate(NodeTypeDefinition ntd) throws RepositoryException {
        JcrNodeTypeTemplate ntt = new JcrNodeTypeTemplate(this.context(), true);
        if (ntd != null) {
            ntt.setName(ntd.getName());
            ntt.setAbstract(ntd.isAbstract());
            ntt.setDeclaredSuperTypeNames(ntd.getDeclaredSupertypeNames());
            ntt.setMixin(ntd.isMixin());
            ntt.setOrderableChildNodes(ntd.hasOrderableChildNodes());
            ntt.setPrimaryItemName(ntd.getPrimaryItemName());
            ntt.setQueryable(ntd.isQueryable());
            for (NodeDefinition nodeDefinition : ntd.getDeclaredChildNodeDefinitions()) {
                JcrNodeDefinitionTemplate ndt = new JcrNodeDefinitionTemplate(this.context());
                ndt.setAutoCreated(nodeDefinition.isAutoCreated());
                ndt.setDefaultPrimaryTypeName(nodeDefinition.getDefaultPrimaryTypeName());
                ndt.setMandatory(nodeDefinition.isMandatory());
                if (nodeDefinition.getName() != null) {
                    ndt.setName(nodeDefinition.getName());
                }
                ndt.setOnParentVersion(nodeDefinition.getOnParentVersion());
                ndt.setProtected(nodeDefinition.isProtected());
                ndt.setRequiredPrimaryTypeNames(nodeDefinition.getRequiredPrimaryTypeNames());
                ndt.setSameNameSiblings(nodeDefinition.allowsSameNameSiblings());
                ntt.getNodeDefinitionTemplates().add(ndt);
            }
            for (NodeDefinition nodeDefinition : ntd.getDeclaredPropertyDefinitions()) {
                JcrPropertyDefinitionTemplate pdt = new JcrPropertyDefinitionTemplate(this.context());
                pdt.setAutoCreated(nodeDefinition.isAutoCreated());
                pdt.setAvailableQueryOperators(nodeDefinition.getAvailableQueryOperators());
                pdt.setDefaultValues(nodeDefinition.getDefaultValues());
                pdt.setFullTextSearchable(nodeDefinition.isFullTextSearchable());
                pdt.setMandatory(nodeDefinition.isMandatory());
                pdt.setMultiple(nodeDefinition.isMultiple());
                if (nodeDefinition.getName() != null) {
                    pdt.setName(nodeDefinition.getName());
                }
                pdt.setOnParentVersion(nodeDefinition.getOnParentVersion());
                pdt.setProtected(nodeDefinition.isProtected());
                pdt.setQueryOrderable(nodeDefinition.isQueryOrderable());
                pdt.setRequiredType(nodeDefinition.getRequiredType());
                pdt.setValueConstraints(nodeDefinition.getValueConstraints());
                ntt.getPropertyDefinitionTemplates().add(pdt);
            }
        }
        return ntt;
    }

    public NodeDefinitionTemplate createNodeDefinitionTemplate() throws RepositoryException {
        return new JcrNodeDefinitionTemplate(this.context());
    }

    public PropertyDefinitionTemplate createPropertyDefinitionTemplate() throws RepositoryException {
        return new JcrPropertyDefinitionTemplate(this.context());
    }

    public boolean isDerivedFrom(String[] testTypeNames, String primaryTypeName, String[] mixinNames) throws RepositoryException {
        CheckArg.isNotEmpty((Object[])testTypeNames, (String)"testTypeNames");
        CheckArg.isNotEmpty((String)primaryTypeName, (String)"primaryTypeName");
        NameFactory nameFactory = this.context().getValueFactories().getNameFactory();
        Name[] typeNames = (Name[])nameFactory.create(testTypeNames);
        for (Name typeName : typeNames) {
            JcrNodeType nodeType = this.getNodeType(typeName);
            if (nodeType == null || !nodeType.isNodeType(primaryTypeName)) continue;
            return true;
        }
        if (mixinNames != null) {
            for (String mixin : mixinNames) {
                for (Name typeName : typeNames) {
                    JcrNodeType nodeType = this.getNodeType(typeName);
                    if (nodeType == null || !nodeType.isNodeType(mixin)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected String messageFrom(Problems problems) {
        StringBuilder sb = new StringBuilder();
        for (Problem problem : problems) {
            sb.append('\n').append(problem.getMessageString());
        }
        return sb.toString();
    }

    protected List<NodeTypeDefinition> importFromXml(InputSource source) throws RepositoryException {
        XmlNodeTypeReader handler = new XmlNodeTypeReader(this.session);
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(handler);
            parser.parse(source);
        }
        catch (JcrContentHandler.EnclosingSAXException ese) {
            Exception cause = ese.getException();
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)((Object)cause);
            }
            throw new RepositoryException((Throwable)cause);
        }
        catch (SAXParseException se) {
            throw new InvalidSerializedDataException((Throwable)se);
        }
        catch (SAXException se) {
            throw new RepositoryException((Throwable)se);
        }
        catch (IOException ioe) {
            throw new RepositoryException((Throwable)ioe);
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new RepositoryException(t);
        }
        return handler.getNodeTypeDefinitions();
    }

    public NodeTypeIterator registerNodeTypes(File file, boolean allowUpdate) throws IOException, RepositoryException {
        String content = IoUtil.read((File)file);
        if (content.startsWith("<?xml")) {
            return this.registerNodeTypes(this.importFromXml(new InputSource(new FileInputStream(file))), allowUpdate);
        }
        CndImporter importer = new CndImporter(this.context(), true);
        SimpleProblems problems = new SimpleProblems();
        importer.importFrom(content, (Problems)problems, file.getAbsolutePath());
        if (problems.hasProblems()) {
            String summary = this.messageFrom((Problems)problems);
            if (problems.hasErrors()) {
                String msg = JcrI18n.errorsParsingNodeTypeDefinitions.text(new Object[]{file.getAbsolutePath(), summary});
                throw new RepositoryException(msg);
            }
            I18n msg = JcrI18n.warningsParsingNodeTypeDefinitions;
            Logger.getLogger(this.getClass()).warn(msg, new Object[]{file.getAbsolutePath(), summary});
        }
        return this.registerNodeTypes(importer.getNodeTypeDefinitions(), allowUpdate);
    }

    public NodeTypeIterator registerNodeTypes(InputStream stream, boolean allowUpdate) throws IOException, InvalidNodeTypeDefinitionException, javax.jcr.nodetype.NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        String content = IoUtil.read((InputStream)stream);
        if (content.startsWith("<?xml")) {
            return this.registerNodeTypes(this.importFromXml(new InputSource(new StringReader(content))), allowUpdate);
        }
        CndImporter importer = new CndImporter(this.context(), true);
        SimpleProblems problems = new SimpleProblems();
        importer.importFrom(content, (Problems)problems, "stream");
        if (problems.hasProblems()) {
            String summary = this.messageFrom((Problems)problems);
            if (problems.hasErrors()) {
                String msg = JcrI18n.errorsParsingStreamOfNodeTypeDefinitions.text(new Object[]{summary});
                throw new RepositoryException(msg);
            }
            I18n msg = JcrI18n.warningsParsingStreamOfNodeTypeDefinitions;
            Logger.getLogger(this.getClass()).warn(msg, new Object[]{summary});
        }
        return this.registerNodeTypes(importer.getNodeTypeDefinitions(), allowUpdate);
    }

    public NodeTypeIterator registerNodeTypes(URL url, boolean allowUpdate) throws IOException, RepositoryException {
        String content = IoUtil.read((InputStream)url.openStream());
        if (content.startsWith("<?xml")) {
            return this.registerNodeTypes(this.importFromXml(new InputSource(new StringReader(content))), allowUpdate);
        }
        CndImporter importer = new CndImporter(this.context(), true);
        SimpleProblems problems = new SimpleProblems();
        importer.importFrom(content, (Problems)problems, url.toExternalForm());
        if (problems.hasProblems()) {
            String summary = this.messageFrom((Problems)problems);
            if (problems.hasErrors()) {
                String msg = JcrI18n.errorsParsingNodeTypeDefinitions.text(new Object[]{url.toExternalForm(), summary});
                throw new RepositoryException(msg);
            }
            I18n msg = JcrI18n.warningsParsingNodeTypeDefinitions;
            Logger.getLogger(this.getClass()).warn(msg, new Object[]{url.toExternalForm(), summary});
        }
        return this.registerNodeTypes(importer.getNodeTypeDefinitions(), allowUpdate);
    }
}

