/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache;

import java.util.HashMap;
import java.util.Map;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Path;

public class PathCache {
    private final NodeCache cache;
    private final Map<NodeKey, Path> paths = new HashMap<NodeKey, Path>();

    public PathCache(NodeCache cache) {
        this.cache = cache;
    }

    public Path getPath(CachedNode node) {
        NodeKey key = node.getKey();
        Path path = this.paths.get(key);
        if (path == null) {
            path = node.getPath(this.cache);
            this.paths.put(key, path);
        }
        return path;
    }

    public boolean removePath(NodeKey key) {
        return this.paths.remove(key) != null;
    }
}

