/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.component;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.component.ThreadPoolFactory;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.NamedThreadFactory;

@ThreadSafe
public class ThreadPools
implements ThreadPoolFactory {
    public static final String DEFAULT_THREAD_NAME = "modeshape-workers";
    public static final int DEFAULT_MAX_THREAD_COUNT = 4;
    private final int defaultMaxThreadCount;
    private final ThreadFactory threadFactory;
    private final ConcurrentMap<String, ThreadPoolHolder> poolsByName = new ConcurrentHashMap<String, ThreadPoolHolder>();

    public ThreadPools() {
        this.threadFactory = new NamedThreadFactory(DEFAULT_THREAD_NAME);
        this.defaultMaxThreadCount = 4;
    }

    public ThreadPools(int defaultMaxThreads, String threadFactoryName) {
        CheckArg.isGreaterThan(0, defaultMaxThreads, "defaultMaxThreads");
        if (threadFactoryName == null || threadFactoryName.trim().length() == 0) {
            threadFactoryName = DEFAULT_THREAD_NAME;
        }
        this.threadFactory = new NamedThreadFactory(threadFactoryName);
        this.defaultMaxThreadCount = defaultMaxThreads;
    }

    public ThreadPools(int defaultMaxThreads, ThreadFactory threadFactory) {
        CheckArg.isGreaterThan(0, defaultMaxThreads, "defaultMaxThreads");
        CheckArg.isNotNull(threadFactory, "threadFactory");
        this.threadFactory = threadFactory;
        this.defaultMaxThreadCount = defaultMaxThreads;
    }

    @Override
    public Executor getThreadPool(String name) {
        ThreadPoolHolder pool = (ThreadPoolHolder)this.poolsByName.get(name);
        if (pool == null) {
            ExecutorService newExecutor = Executors.newFixedThreadPool(this.defaultMaxThreadCount, this.threadFactory);
            ThreadPoolHolder newPool = new ThreadPoolHolder(newExecutor);
            pool = this.poolsByName.putIfAbsent(name, newPool);
            if (pool != null) {
                newExecutor.shutdownNow();
            } else {
                pool = newPool;
            }
        }
        pool.users.incrementAndGet();
        return pool.threadPool;
    }

    @Override
    public void releaseThreadPool(Executor pool) {
        for (ThreadPoolHolder holder : this.poolsByName.values()) {
            if (!holder.release(pool)) continue;
            return;
        }
    }

    protected static final class ThreadPoolHolder {
        protected final ExecutorService threadPool;
        protected final AtomicInteger users = new AtomicInteger(0);

        protected ThreadPoolHolder(ExecutorService threadPool) {
            this.threadPool = threadPool;
        }

        protected boolean release(Executor pool) {
            if (this.threadPool == pool) {
                if (this.users.decrementAndGet() == 0) {
                    this.threadPool.shutdown();
                }
                return true;
            }
            return false;
        }
    }
}

