/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.TUNNEL;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.Promise;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;

@DeprecatedProperty(names={"gossip_refresh_rate"})
public class TCPGOSSIP
extends Discovery
implements RouterStub.ConnectionListener {
    @Property(description="Max time for socket creation. Default is 1000 msec")
    int sock_conn_timeout = 1000;
    @Property(description="Max time in milliseconds to block on a read. 0 blocks forever")
    int sock_read_timeout = 3000;
    @Property(description="Interval (ms) by which a disconnected stub attempts to reconnect to the GossipRouter")
    long reconnect_interval = 10000L;
    List<InetSocketAddress> initial_hosts = null;
    final List<RouterStub> stubs = new ArrayList<RouterStub>();
    Future<?> reconnect_future = null;
    Future<?> connection_checker = null;
    protected volatile boolean running = true;

    @Property(name="initial_hosts", description="Comma delimited list of hosts to be contacted for initial membership", converter=PropertyConverters.InitialHosts2.class)
    public void setInitialHosts(List<InetSocketAddress> initial_hosts) {
        if (initial_hosts == null || initial_hosts.isEmpty()) {
            throw new IllegalArgumentException("initial_hosts must contain the address of at least one GossipRouter");
        }
        this.initial_hosts = initial_hosts;
    }

    public List<InetSocketAddress> getInitialHosts() {
        return this.initial_hosts;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.timeout <= (long)this.sock_conn_timeout) {
            throw new IllegalArgumentException("timeout (" + this.timeout + ") must be greater than sock_conn_timeout (" + this.sock_conn_timeout + ")");
        }
        TP transport = this.getTransport();
        if (transport instanceof TUNNEL) {
            throw new IllegalStateException("TCPGOSSIP cannot be used with TUNNEL; use either TUNNEL:PING or TCP:TCPGOSSIP as valid configurations");
        }
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.running = true;
    }

    @Override
    public void stop() {
        super.stop();
        this.running = false;
        for (RouterStub stub : this.stubs) {
            try {
                stub.disconnect(this.group_addr, this.local_addr);
            }
            catch (Exception exception) {}
        }
        this.stopReconnector();
    }

    @Override
    public void destroy() {
        for (RouterStub stub : this.stubs) {
            stub.destroy();
        }
        super.destroy();
    }

    @Override
    public void handleConnect() {
        if (this.group_addr == null || this.local_addr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("group_addr or local_addr is null, cannot register with GossipRouter(s)");
            }
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace("registering " + this.local_addr + " under " + this.group_addr + " with GossipRouter");
            }
            for (RouterStub stub : this.stubs) {
                stub.destroy();
            }
            this.stubs.clear();
            for (InetSocketAddress host : this.initial_hosts) {
                RouterStub stub = new RouterStub(host.getHostName(), host.getPort(), null);
                stub.setConnectionListener(this);
                this.stubs.add(stub);
            }
            this.connect(this.group_addr, this.local_addr);
            this.startConnectionChecker();
        }
    }

    @Override
    public void handleDisconnect() {
        for (RouterStub stub : this.stubs) {
            try {
                stub.disconnect(this.group_addr, this.local_addr);
                stub.destroy();
            }
            catch (Exception exception) {}
        }
        this.stopConnectionChecker();
    }

    @Override
    public void connectionStatusChange(RouterStub.ConnectionStatus state) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("connection changed to " + (Object)((Object)state));
        }
        if (state == RouterStub.ConnectionStatus.CONNECTED) {
            this.stopReconnector();
        } else {
            this.startReconnector();
        }
    }

    @Override
    public void sendGetMembersRequest(String cluster_name, Promise promise, boolean return_views_only) throws Exception {
        if (this.group_addr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("cluster_name is null, cannot get membership");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("fetching members from GossipRouter(s)");
        }
        LinkedList<PingData> responses = new LinkedList<PingData>();
        for (RouterStub stub : this.stubs) {
            try {
                List<PingData> rsps = stub.getMembers(this.group_addr);
                responses.addAll(rsps);
            }
            catch (Throwable e) {}
        }
        HashSet<Address> initial_mbrs = new HashSet<Address>();
        for (PingData rsp : responses) {
            String logical_name;
            Address logical_addr = rsp.getAddress();
            initial_mbrs.add(logical_addr);
            Collection<PhysicalAddress> physical_addrs = rsp.getPhysicalAddrs();
            if (physical_addrs != null) {
                for (PhysicalAddress physical_addr : physical_addrs) {
                    this.down(new Event(89, new Tuple<Address, PhysicalAddress>(logical_addr, physical_addr)));
                }
            }
            if ((logical_name = rsp.getLogicalName()) == null || !(logical_addr instanceof UUID)) continue;
            UUID.add((UUID)logical_addr, logical_name);
        }
        if (initial_mbrs.isEmpty()) {
            if (this.log.isErrorEnabled()) {
                this.log.error("[FIND_INITIAL_MBRS]: found no members");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("consolidated mbrs from GossipRouter(s) are " + initial_mbrs);
        }
        for (Address mbr_addr : initial_mbrs) {
            Message msg = new Message(mbr_addr);
            msg.setFlag((byte)1);
            PingHeader hdr = new PingHeader(1, cluster_name);
            hdr.return_view_only = return_views_only;
            msg.putHeader(this.name, hdr);
            if (this.log.isTraceEnabled()) {
                this.log.trace("[FIND_INITIAL_MBRS] sending PING request to " + mbr_addr);
            }
            this.down_prot.down(new Event(1, msg));
        }
    }

    synchronized void startReconnector() {
        if (this.running && (this.reconnect_future == null || this.reconnect_future.isDone())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("starting reconnector");
            }
            this.reconnect_future = this.timer.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    TCPGOSSIP.this.connect(TCPGOSSIP.this.group_addr, TCPGOSSIP.this.local_addr);
                }
            }, 0L, this.reconnect_interval, TimeUnit.MILLISECONDS);
        }
    }

    synchronized void stopReconnector() {
        if (this.reconnect_future != null) {
            this.reconnect_future.cancel(false);
            this.reconnect_future = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("stopping reconnector");
            }
        }
    }

    synchronized void startConnectionChecker() {
        if (this.running && (this.connection_checker == null || this.connection_checker.isDone())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("starting connection checker");
            }
            this.connection_checker = this.timer.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    for (RouterStub stub : TCPGOSSIP.this.stubs) {
                        stub.checkConnection();
                    }
                }
            }, 0L, this.reconnect_interval, TimeUnit.MILLISECONDS);
        }
    }

    synchronized void stopConnectionChecker() {
        if (this.connection_checker != null) {
            this.connection_checker.cancel(false);
            this.connection_checker = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("stopping connection checker");
            }
        }
    }

    protected void connect(String group, Address logical_addr) {
        ArrayList<PhysicalAddress> physical_addrs;
        String logical_name = UUID.get(logical_addr);
        PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, this.local_addr));
        ArrayList<PhysicalAddress> arrayList = physical_addrs = physical_addr != null ? new ArrayList<PhysicalAddress>() : null;
        if (physical_addr != null) {
            physical_addrs.add(physical_addr);
        }
        int num_faulty_conns = 0;
        for (RouterStub stub : this.stubs) {
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("trying to connect to " + stub.getGossipRouterAddress());
                }
                stub.connect(group, logical_addr, logical_name, physical_addrs);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed connecting to " + stub.getGossipRouterAddress() + ": " + e);
                }
                ++num_faulty_conns;
            }
        }
        if (num_faulty_conns == 0) {
            this.stopReconnector();
        }
    }
}

