/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Util;

public class RequestOptions {
    private int mode = 6;
    private long timeout;
    private boolean use_anycasting;
    private RspFilter rsp_filter;
    private short scope;
    private byte flags;
    private Set<Address> exclusion_list;
    public static final RequestOptions SYNC = new RequestOptions(2, 5000L);
    public static final RequestOptions ASYNC = new RequestOptions(6, 5000L);

    public RequestOptions() {
    }

    public RequestOptions(int mode, long timeout, boolean use_anycasting, RspFilter rsp_filter, byte flags) {
        this.mode = mode;
        this.timeout = timeout;
        this.use_anycasting = use_anycasting;
        this.rsp_filter = rsp_filter;
        this.flags = flags;
    }

    public RequestOptions(int mode, long timeout, boolean use_anycasting, RspFilter rsp_filter) {
        this(mode, timeout, use_anycasting, rsp_filter, 0);
    }

    public RequestOptions(int mode, long timeout) {
        this(mode, timeout, false, null);
    }

    public int getMode() {
        return this.mode;
    }

    public RequestOptions setMode(int mode) {
        this.mode = mode;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RequestOptions setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public boolean getAnycasting() {
        return this.use_anycasting;
    }

    public RequestOptions setAnycasting(boolean use_anycasting) {
        this.use_anycasting = use_anycasting;
        return this;
    }

    public short getScope() {
        return this.scope;
    }

    public RequestOptions setScope(short scope) {
        this.scope = scope;
        return this;
    }

    public RspFilter getRspFilter() {
        return this.rsp_filter;
    }

    public RequestOptions setRspFilter(RspFilter rsp_filter) {
        this.rsp_filter = rsp_filter;
        return this;
    }

    public byte getFlags() {
        return this.flags;
    }

    public RequestOptions setFlags(byte flags) {
        this.flags = Util.setFlag(this.flags, flags);
        return this;
    }

    public RequestOptions clearFlags(byte flags) {
        this.flags = Util.clearFlags(this.flags, flags);
        return this;
    }

    public boolean hasExclusionList() {
        return this.exclusion_list != null && !this.exclusion_list.isEmpty();
    }

    public Collection<Address> getExclusionList() {
        if (this.exclusion_list == null) {
            return this.exclusion_list;
        }
        return Collections.unmodifiableCollection(this.exclusion_list);
    }

    public RequestOptions setExclusionList(Address ... mbrs) {
        if (this.exclusion_list == null) {
            this.exclusion_list = new HashSet<Address>();
        } else {
            this.exclusion_list.clear();
        }
        this.exclusion_list.addAll(Arrays.asList(mbrs));
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("mode=" + Request.modeToString(this.mode));
        sb.append(", timeout=" + this.timeout);
        if (this.use_anycasting) {
            sb.append(", anycasting=true");
        }
        sb.append(", flags=" + Message.flagsToString(this.flags));
        if (this.scope > 0) {
            sb.append(", scope=" + this.scope);
        }
        if (this.exclusion_list != null) {
            sb.append(", exclusion list: " + Util.print(this.exclusion_list));
        }
        return sb.toString();
    }
}

