/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.clustering;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.jgroups.Address;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.modeshape.clustering.ClusteredObservationBus;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CreateNodeRequest;

public class ClusteredObservationBusTest {
    private ClusteredObservationBus bus;
    private ExecutionContext context = new ExecutionContext();
    protected JChannel mockChannel;
    protected View mockView;
    protected Vector<Address> channelMembers;

    @Before
    public void beforeEach() {
        JChannel mockChannel;
        this.mockChannel = mockChannel = (JChannel)Mockito.mock(JChannel.class);
        this.bus = new ClusteredObservationBus(){

            protected JChannel newChannel(String configuration) {
                return mockChannel;
            }
        };
        this.channelMembers = new Vector();
        this.mockView = (View)Mockito.mock(View.class);
        Mockito.stub((Object)mockChannel.getView()).toReturn((Object)this.mockView);
        Mockito.stub((Object)this.mockView.getMembers()).toReturn(this.channelMembers);
    }

    @Test
    public void shouldSerializeAndDeserializeChanges() throws Exception {
        Changes changes = this.changes();
        byte[] data = ClusteredObservationBus.serialize((Changes)changes);
        Changes deserialized = ClusteredObservationBus.deserialize((byte[])data);
        Assert.assertThat((Object)changes, Is.is(deserialized));
        Assert.assertThat((Object)changes, Is.is(IsNot.not(IsSame.sameInstance(deserialized))));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowSettingClusterNameToNull() {
        this.bus.setClusterName(null);
    }

    @Test
    public void shouldAllowSettingClusterNameToBlankString() {
        this.setAndGetClusterName("");
    }

    @Test
    public void shouldAllowSettingClusterNameToStringWithAlphaNumericCharacters() {
        this.setAndGetClusterName("abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    @Test
    public void shouldAllowSettingClusterNameToStringWithAlphaNumericAndPunctuationCharacters() {
        this.setAndGetClusterName("valid.cluster!name@#$%^&*()<>?,./:\"'[]\\{}|_+-=");
    }

    @Test
    public void shouldAllowSettingClusterNameToStringWithAlphaNumericAndWhitespaceCharacters() {
        this.setAndGetClusterName("valid cluster name");
    }

    @Test
    public void shouldAllowSettingConfigurationToNull() {
        this.setAndGetConfiguration(null);
    }

    @Test
    public void shouldAllowSettingConfigurationToBlankString() {
        this.setAndGetConfiguration(null);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotAllowStartingWithoutSettingClusterName() {
        Assert.assertThat((Object)this.bus.getClusterName(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
        this.bus.start();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(true));
        this.bus.shutdown();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
    }

    @Test
    public void shouldAllowStartingWithoutSettingConfiguration() {
        this.bus.setClusterName("clusterName");
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
        this.bus.start();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(true));
        this.bus.shutdown();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
    }

    @Test
    public void shouldAllowShuttingDownWithoutHavingStarted() {
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
        this.bus.shutdown();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotAllowSettingConfigurationAfterBusHasBeenStartedButBeforeBusHasBeenShutdown() {
        this.bus.setClusterName("clusterName");
        this.bus.setConfiguration("old configuration");
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
        this.bus.start();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(true));
        this.bus.setConfiguration("new configuration");
    }

    @Test
    public void shouldAllowSettingConfigurationAfterBusHasBeenStartedAndShutdown() {
        this.bus.setClusterName("clusterName");
        this.bus.setConfiguration("old configuration");
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
        this.bus.start();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(true));
        this.bus.shutdown();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
        this.bus.setConfiguration("new configuration");
    }

    @Test
    public void shouldAllowNotifyToBeCalledBeforeStartButShouldDoNothing() throws Exception {
        this.bus.setClusterName("clusterName");
        this.bus.notify(this.changes());
        ArgumentCaptor argument = ArgumentCaptor.forClass(Message.class);
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.never())).send((Message)argument.capture());
    }

    @Test
    public void shouldAllowNotifyToBeCalledAfterStartWithMultipleMembersAndShouldSendMessageToJGroups() throws Exception {
        this.bus.setClusterName("clusterName");
        this.bus.start();
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.times((int)1))).addChannelListener((ChannelListener)ArgumentCaptor.forClass(ChannelListener.class).capture());
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.times((int)1))).connect("clusterName");
        ArgumentCaptor receiverArgument = ArgumentCaptor.forClass(Receiver.class);
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.times((int)1))).setReceiver((Receiver)receiverArgument.capture());
        this.setChannelMemberCount(2);
        ((Receiver)receiverArgument.getValue()).viewAccepted(this.mockView);
        this.bus.isOpen.set(true);
        this.bus.notify(this.changes());
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.times((int)1))).send((Message)ArgumentCaptor.forClass(Message.class).capture());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockChannel});
    }

    @Test
    public void shouldAllowNotifyToBeCalledAfterStartWithOneMemberAndShouldSendMessageToLocalObserversBuNotJGroups() throws Exception {
        this.setChannelMemberCount(1);
        this.bus.setClusterName("clusterName");
        this.bus.start();
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.times((int)1))).addChannelListener((ChannelListener)ArgumentCaptor.forClass(ChannelListener.class).capture());
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.times((int)1))).connect("clusterName");
        ArgumentCaptor receiverArgument = ArgumentCaptor.forClass(Receiver.class);
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.times((int)1))).setReceiver((Receiver)receiverArgument.capture());
        this.setChannelMemberCount(1);
        ((Receiver)receiverArgument.getValue()).viewAccepted(this.mockView);
        this.bus.isOpen.set(true);
        Observer observer = (Observer)Mockito.mock(Observer.class);
        this.bus.register(observer);
        Changes changes = this.changes();
        this.bus.notify(changes);
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.never())).send((Message)ArgumentCaptor.forClass(Message.class).capture());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockChannel});
        ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).notify(changes);
    }

    protected void setChannelMemberCount(int count) {
        while (this.channelMembers.size() > count) {
            this.channelMembers.remove(this.channelMembers.size() - 1);
        }
        while (this.channelMembers.size() < count) {
            this.channelMembers.add((Address)Mockito.mock(Address.class));
        }
    }

    protected void setAndGetClusterName(String name) {
        this.bus.setClusterName(name);
        String nameAfter = this.bus.getClusterName();
        Assert.assertThat((Object)nameAfter, Is.is(name));
    }

    protected void setAndGetConfiguration(String config) {
        this.bus.setConfiguration(config);
        String configAfter = this.bus.getConfiguration();
        Assert.assertThat((Object)configAfter, Is.is(config));
    }

    protected Changes changes() {
        DateTime now = this.context.getValueFactories().getDateFactory().create();
        Path path = (Path)this.context.getValueFactories().getPathFactory().create("/a");
        Name childName = (Name)this.context.getValueFactories().getNameFactory().create("b");
        Path childPath = this.context.getValueFactories().getPathFactory().create(path, new Name[]{childName});
        CreateNodeRequest request = new CreateNodeRequest(Location.create((Path)path), "workspaceName", childName, new Property[0]);
        request.setActualLocationOfNode(Location.create((Path)childPath));
        List<CreateNodeRequest> requests = Collections.singletonList(request);
        return new Changes("processId", "contextId", "username", "sourceName", now, requests, null);
    }
}

