/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.jgroups.util.UnmodifiableVector;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class UnmodifiableVectorTest {
    public static void testCreation() {
        Vector<String> v = new Vector<String>(Arrays.asList("one", "two"));
        UnmodifiableVector uv = new UnmodifiableVector(v);
        Assert.assertEquals((int)v.size(), (int)uv.size());
        assert (uv.contains("two"));
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public static void testAddition() {
        Vector<String> v = new Vector<String>(Arrays.asList("one", "two"));
        UnmodifiableVector uv = new UnmodifiableVector(v);
        uv.add("three");
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public static void testRemoval() {
        Vector<String> v = new Vector<String>(Arrays.asList("one", "two"));
        UnmodifiableVector uv = new UnmodifiableVector(v);
        uv.add("two");
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public static void testIteration() {
        Vector<String> v = new Vector<String>(Arrays.asList("one", "two"));
        UnmodifiableVector uv = new UnmodifiableVector(v);
        for (Object el : uv) {
            System.out.println(el);
        }
        Iterator it = uv.iterator();
        while (it.hasNext()) {
            Object el;
            el = it.next();
            it.remove();
        }
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public static void testListIteration() {
        Object el;
        Vector<String> v = new Vector<String>(Arrays.asList("one", "two"));
        UnmodifiableVector uv = new UnmodifiableVector(v);
        ListIterator it = uv.listIterator();
        while (it.hasNext()) {
            el = it.next();
            System.out.println(el);
        }
        it = uv.listIterator();
        while (it.hasNext()) {
            el = it.next();
            it.remove();
        }
    }
}

