/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class GroupRequest
extends Request {
    private final Map<Address, Rsp> requests;
    int num_received;
    int num_not_received;
    int num_suspected;

    public GroupRequest(Message msg, RequestCorrelator corr, Collection<Address> targets, RequestOptions options) {
        super(msg, corr, null, options);
        int size = targets.size();
        this.requests = new HashMap<Address, Rsp>(size);
        this.setTargets(targets);
    }

    public GroupRequest(Message m, RequestCorrelator corr, Address target, RequestOptions options) {
        super(m, corr, null, options);
        this.requests = new HashMap<Address, Rsp>(1);
        this.setTarget(target);
    }

    public GroupRequest(Message m, Transport transport, Collection<Address> mbrs, RequestOptions options) {
        super(m, null, transport, options);
        int size = mbrs.size();
        this.requests = new HashMap<Address, Rsp>(size);
        this.setTargets(mbrs);
    }

    public boolean getAnycasting() {
        return this.options.getAnycasting();
    }

    public void setAnycasting(boolean anycasting) {
        this.options.setAnycasting(anycasting);
    }

    @Override
    public void sendRequest() throws Exception {
        this.sendRequest(this.requests.keySet(), this.req_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveResponse(Object response_value, Address sender) {
        if (this.done) {
            return;
        }
        Rsp rsp = this.requests.get(sender);
        if (rsp == null) {
            return;
        }
        RspFilter rsp_filter = this.options.getRspFilter();
        boolean responseReceived = false;
        if (!rsp.wasReceived()) {
            responseReceived = rsp_filter == null || rsp_filter.isAcceptable(response_value, sender);
            if (responseReceived) {
                rsp.setValue(response_value);
            }
            rsp.setReceived(responseReceived);
        }
        this.lock.lock();
        try {
            if (responseReceived) {
                ++this.num_received;
            }
            boolean bl = rsp_filter == null ? this.responsesComplete() : (this.done = !rsp_filter.needMoreResponses());
            if (responseReceived || this.done) {
                this.completed.signalAll();
            }
            if (this.done && this.corr != null) {
                this.corr.done(this.req_id);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (responseReceived || this.done) {
            this.checkCompletion(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspect(Address suspected_member) {
        if (suspected_member == null) {
            return;
        }
        boolean changed = false;
        Rsp rsp = this.requests.get(suspected_member);
        if (rsp != null && rsp.setSuspected(true)) {
            rsp.setValue(null);
            changed = true;
            this.lock.lock();
            try {
                ++this.num_suspected;
                this.completed.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
        if (changed) {
            this.checkCompletion(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChange(View new_view) {
        Vector<Address> mbrs;
        Vector<Address> vector = mbrs = new_view != null ? new_view.getMembers() : null;
        if (mbrs == null) {
            return;
        }
        boolean changed = false;
        if (this.requests == null || this.requests.isEmpty()) {
            return;
        }
        this.lock.lock();
        try {
            for (Map.Entry<Address, Rsp> entry : this.requests.entrySet()) {
                Address mbr = entry.getKey();
                if (mbrs.contains(mbr)) continue;
                Rsp rsp = entry.getValue();
                rsp.setValue(null);
                if (!rsp.setSuspected(true)) continue;
                ++this.num_suspected;
                changed = true;
            }
            if (changed) {
                this.completed.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (changed) {
            this.checkCompletion(this);
        }
    }

    public RspList getResults() {
        Collection<Rsp> rsps = this.requests.values();
        return new RspList(rsps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RspList get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            this.waitForResults(0L);
        }
        finally {
            this.lock.unlock();
        }
        return this.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RspList get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean ok;
        this.lock.lock();
        try {
            ok = this.waitForResults(unit.toMillis(timeout));
        }
        finally {
            this.lock.unlock();
        }
        if (!ok) {
            throw new TimeoutException();
        }
        return this.getResults();
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder(128);
        ret.append(super.toString());
        if (!this.requests.isEmpty()) {
            ret.append(", entries:\n");
            for (Map.Entry<Address, Rsp> entry : this.requests.entrySet()) {
                Address mbr = entry.getKey();
                Rsp rsp = entry.getValue();
                ret.append(mbr).append(": ").append(rsp).append("\n");
            }
        }
        return ret.toString();
    }

    private void setTarget(Address mbr) {
        this.requests.put(mbr, new Rsp(mbr));
        this.num_not_received = 1;
    }

    private void setTargets(Collection<Address> mbrs) {
        for (Address mbr : mbrs) {
            this.requests.put(mbr, new Rsp(mbr));
        }
        this.num_not_received = this.requests.size();
    }

    private static int determineMajority(int i) {
        return i < 2 ? i : i / 2 + 1;
    }

    private void sendRequest(Collection<Address> targetMembers, long requestId) throws Exception {
        try {
            if (this.corr != null) {
                this.corr.sendRequest(requestId, targetMembers, this.request_msg, this.options.getMode() == 6 ? null : this, this.options);
            } else if (this.options.getAnycasting()) {
                for (Address mbr : targetMembers) {
                    Message copy = this.request_msg.copy(true);
                    copy.setDest(mbr);
                    this.transport.send(copy);
                }
            } else {
                this.transport.send(this.request_msg);
            }
        }
        catch (Exception ex) {
            if (this.corr != null) {
                this.corr.done(requestId);
            }
            throw ex;
        }
    }

    @Override
    protected boolean responsesComplete() {
        if (this.done) {
            return true;
        }
        int num_total = this.requests.size();
        switch (this.options.getMode()) {
            case 1: {
                if (this.num_received > 0) {
                    return true;
                }
                if (this.num_suspected < num_total) break;
                return true;
            }
            case 2: {
                return this.num_received + this.num_suspected >= num_total;
            }
            case 3: {
                int majority = GroupRequest.determineMajority(num_total);
                if (this.num_received + this.num_suspected < majority) break;
                return true;
            }
            case 4: {
                int majority = GroupRequest.determineMajority(num_total);
                if (this.num_received < majority) break;
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error("rsp_mode " + this.options.getMode() + " unknown !");
            }
        }
        return false;
    }
}

