/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataOutputStream;
import java.io.Serializable;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.Version;
import org.jgroups.protocols.TpHeader;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.ExposedDataOutputStream;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class MessageSizeTest {
    private static final byte MULTICAST = 2;
    private static final short UDP_ID = 100;
    private static final short UNICAST_ID = 101;
    private static final short NAKACK_ID = 102;
    private static final int MCAST_MAX_SIZE = 84;
    private static final int UNICAST_MAX_SIZE = 102;

    public static void testMulticast() throws Exception {
        Address src = Util.createRandomAddress();
        Message msg = MessageSizeTest.createMessage(null, src);
        Buffer buf = MessageSizeTest.marshal(msg);
        System.out.println("buf = " + buf);
        int len = buf.getLength();
        System.out.println("len = " + len);
        assert (len <= 84);
        if (len < 84) {
            double percentage = MessageSizeTest.compute(len, 84);
            System.out.println("multicast message (" + len + " bytes) is " + Util.format(percentage) + "% smaller than previous max size (" + 84 + " bytes)");
        }
    }

    public static void testUnicast() throws Exception {
        Address dest = Util.createRandomAddress();
        Address src = Util.createRandomAddress();
        Message msg = MessageSizeTest.createMessage(dest, src);
        Buffer buf = MessageSizeTest.marshal(msg);
        System.out.println("buf = " + buf);
        int len = buf.getLength();
        System.out.println("len = " + len);
        assert (len <= 102);
        if (len < 102) {
            double percentage = MessageSizeTest.compute(len, 102);
            System.out.println("multicast message (" + len + " bytes) is " + Util.format(percentage) + "% smaller than previous max size (" + 102 + " bytes)");
        }
    }

    private static double compute(int new_length, int old_length) {
        if (new_length >= old_length) {
            return 0.0;
        }
        return 100.0 * (1.0 - (double)new_length / (double)old_length);
    }

    private static Buffer marshal(Message msg) throws Exception {
        ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream((int)(msg.size() + 50L));
        ExposedDataOutputStream dos = new ExposedDataOutputStream(out_stream);
        Address dest = msg.getDest();
        boolean multicast = dest == null || dest.isMulticastAddress();
        MessageSizeTest.writeMessage(msg, dos, multicast);
        return new Buffer(out_stream.getRawBuffer(), 0, out_stream.size());
    }

    protected static void writeMessage(Message msg, DataOutputStream dos, boolean multicast) throws Exception {
        int flags = 0;
        dos.writeShort(Version.version);
        if (multicast) {
            flags = (byte)(flags + 2);
        }
        dos.writeByte(flags);
        msg.writeTo(dos);
    }

    static Message createMessage(Address dest, Address src) {
        Message msg = new Message(dest, src, (Serializable)((Object)"hello world"));
        msg.putHeader((short)102, NakAckHeader.createMessageHeader(322649L));
        msg.putHeader((short)101, UNICAST.UnicastHeader.createDataHeader(465784L, (short)23323, true));
        msg.putHeader((short)100, new TpHeader("DrawDemo"));
        return msg;
    }
}

