/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.math;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.math.Duration;

public class DurationTest {
    private Duration duration;

    @Before
    public void beforeEach() {
        this.duration = new Duration(0L);
    }

    @Test
    public void shouldBeEmptyWhenInitialized() {
        Assert.assertEquals((long)0L, (long)this.duration.getComponents().getHours());
        Assert.assertEquals((long)0L, (long)this.duration.getComponents().getMinutes());
        Assert.assertEquals((double)0.0, (double)this.duration.getComponents().getSeconds(), (double)1.0E-5);
    }

    @Test
    public void shouldHaveComponentsWhenInitialized() {
        Assert.assertNotNull((Object)this.duration.getComponents());
    }

    @Test
    public void shouldBeAllowedToAddSeconds() {
        this.duration = this.duration.add(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)this.duration.getComponents().getHours());
        Assert.assertEquals((long)0L, (long)this.duration.getComponents().getMinutes());
        Assert.assertEquals((double)1.0, (double)this.duration.getComponents().getSeconds(), (double)1.0E-5);
    }

    @Test
    public void shouldRepresentTimeInProperFormat() {
        this.duration = this.duration.add(2L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)"00:00:02.000", (Object)this.duration.toString());
        this.duration = new Duration(1100L, TimeUnit.MILLISECONDS);
        this.duration = this.duration.add(60L, TimeUnit.SECONDS);
        this.duration = this.duration.add(3600L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)"01:01:01.100", (Object)this.duration.toString());
        this.duration = new Duration(30100123L, TimeUnit.MICROSECONDS);
        this.duration = this.duration.add(1200L, TimeUnit.SECONDS);
        this.duration = this.duration.add(36000L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)"10:20:30.100,123", (Object)this.duration.toString());
    }
}

