/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.text;

import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleSqlParser {
    public List<Statement> parse(String ddl) {
        TokenStream tokens = new TokenStream(ddl, (TokenStream.Tokenizer)TokenStream.basicTokenizer((boolean)false), false);
        LinkedList<Statement> statements = new LinkedList<Statement>();
        tokens.start();
        while (tokens.hasNext()) {
            if (tokens.matches("SELECT")) {
                statements.add(this.parseSelect(tokens));
                continue;
            }
            statements.add(this.parseDelete(tokens));
        }
        return statements;
    }

    protected Select parseSelect(TokenStream tokens) throws ParsingException {
        tokens.consume("SELECT");
        List<Column> columns = this.parseColumns(tokens);
        tokens.consume("FROM");
        String tableName = tokens.consume();
        return new Select(tableName, columns);
    }

    protected List<Column> parseColumns(TokenStream tokens) throws ParsingException {
        LinkedList<Column> columns = new LinkedList<Column>();
        if (tokens.matches('*')) {
            tokens.consume();
        } else {
            do {
                String columnName = tokens.consume();
                if (tokens.canConsume("AS")) {
                    String columnAlias = tokens.consume();
                    columns.add(new Column(columnName, columnAlias));
                    continue;
                }
                columns.add(new Column(columnName, null));
            } while (tokens.canConsume(','));
        }
        return columns;
    }

    protected Delete parseDelete(TokenStream tokens) throws ParsingException {
        tokens.consume("DELETE", new String[]{"FROM"});
        String tableName = tokens.consume();
        tokens.consume("WHERE");
        String lhs = tokens.consume();
        tokens.consume('=');
        String rhs = tokens.consume();
        return new Delete(tableName, new Criteria(lhs, rhs));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static class Query {
        private final String from;
        private final List<Column> columns;

        public Query(String from, List<Column> columns) {
            this.from = from;
            this.columns = columns;
        }

        public String getFrom() {
            return this.from;
        }

        public List<Column> getColumns() {
            return this.columns;
        }
    }

    @Immutable
    public static class Criteria {
        private final String lhs;
        private final String rhs;

        public Criteria(String lhs, String rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public String getLhs() {
            return this.lhs;
        }

        public String getRhs() {
            return this.rhs;
        }
    }

    @Immutable
    public static class Column {
        private final String name;
        private final String alias;

        public Column(String name, String alias) {
            this.name = name;
            this.alias = alias;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    @Immutable
    public static class Delete
    extends Statement {
        private final String from;
        private final Criteria criteria;

        public Delete(String from, Criteria criteria) {
            this.from = from;
            this.criteria = criteria;
        }

        public String getFrom() {
            return this.from;
        }

        public Criteria getCriteria() {
            return this.criteria;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static class Select
    extends Statement {
        private final String from;
        private final List<Column> columns;

        public Select(String from, List<Column> columns) {
            this.from = from;
            this.columns = columns;
        }

        public String getFrom() {
            return this.from;
        }

        public List<Column> getColumns() {
            return this.columns;
        }
    }

    @Immutable
    public static abstract class Statement {
    }
}

