/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import net.jcip.annotations.Immutable;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;

@Immutable
public class Problem {
    public static final int DEFAULT_CODE = 0;
    private final Status status;
    private final I18n message;
    private final Object[] parameters;
    private final Throwable throwable;
    private final int code;
    private final String resource;
    private final String location;

    public Problem(Status status, int code, I18n message, Object[] params, String resource, String location, Throwable throwable) {
        CheckArg.isNotNull((Object)status, "status");
        CheckArg.isNotNull(message, "message");
        this.status = status;
        this.code = code;
        this.message = message;
        this.parameters = params;
        this.resource = resource != null ? resource.trim() : null;
        this.location = location != null ? location.trim() : null;
        this.throwable = throwable;
    }

    public int getCode() {
        return this.code;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMessageString() {
        return this.message.text(this.parameters);
    }

    public I18n getMessage() {
        return this.message;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public String getResource() {
        return this.resource;
    }

    public Status getStatus() {
        return this.status;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public int hashCode() {
        return HashCode.compute(new Object[]{this.status, this.code, this.message, this.resource, this.location});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Problem) {
            Throwable thatThrowable;
            String thatLocation;
            String thatResource;
            Problem that = (Problem)obj;
            if (this.getStatus() != that.getStatus()) {
                return false;
            }
            if (this.getCode() != that.getCode()) {
                return false;
            }
            if (!this.getMessage().equals(that.getMessage())) {
                return false;
            }
            if (!this.getParameters().equals(that.getParameters())) {
                return false;
            }
            String thisResource = this.getResource();
            if (!(thisResource == (thatResource = that.getResource()) || thisResource != null && thisResource.equals(thatResource))) {
                return false;
            }
            String thisLocation = this.getLocation();
            if (!(thisLocation == (thatLocation = that.getLocation()) || thisLocation != null && thisLocation.equals(thatLocation))) {
                return false;
            }
            Throwable thisThrowable = this.getThrowable();
            return thisThrowable == (thatThrowable = that.getThrowable()) || thisThrowable != null && thisThrowable.equals(thatThrowable);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getStatus()).append(": ");
        if (this.getCode() != 0) {
            sb.append("(").append(this.getCode()).append(") ");
        }
        sb.append(this.getMessageString());
        if (this.getResource() != null) {
            sb.append(" Resource=\"").append(this.getResource()).append("\"");
        }
        if (this.getLocation() != null) {
            sb.append(" At \"").append(this.getLocation()).append("\"");
        }
        if (this.getThrowable() != null) {
            sb.append(" (threw ").append(this.getThrowable().getLocalizedMessage()).append(")");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ERROR,
        WARNING,
        INFO;

    }
}

