/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.component;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.CommonI18n;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.component.ClassLoaderFactory;
import org.modeshape.common.component.Component;
import org.modeshape.common.component.ComponentConfig;
import org.modeshape.common.component.StandardClassLoaderFactory;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ComponentLibrary<ComponentType, ConfigType extends ComponentConfig> {
    public static final ClassLoaderFactory DEFAULT = new StandardClassLoaderFactory(ComponentLibrary.class.getClassLoader());
    private final AtomicReference<ClassLoaderFactory> classLoaderFactory = new AtomicReference<ClassLoaderFactory>(DEFAULT);
    @GuardedBy(value="lock")
    private final List<ComponentType> instances = new CopyOnWriteArrayList<ComponentType>();
    private final List<ConfigType> configs = new CopyOnWriteArrayList<ConfigType>();
    private final List<ComponentType> unmodifiableInstances = Collections.unmodifiableList(this.instances);
    private final Lock lock = new ReentrantLock();
    private final boolean addBeforeExistingConfigs;

    public ComponentLibrary() {
        this(false);
    }

    public ComponentLibrary(boolean addBeforeExistingConfigs) {
        this.addBeforeExistingConfigs = addBeforeExistingConfigs;
    }

    public ClassLoaderFactory getClassLoaderFactory() {
        return this.classLoaderFactory.get();
    }

    public void setClassLoaderFactory(ClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory.set(classLoaderFactory != null ? classLoaderFactory : DEFAULT);
        this.refreshInstances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ConfigType config) {
        CheckArg.isNotNull(config, "component configuration");
        try {
            this.lock.lock();
            int index = this.findIndexOfMatchingConfiguration(config);
            if (index >= 0) {
                ComponentConfig existingConfig = (ComponentConfig)this.configs.get(index);
                if (existingConfig.hasChanged((ComponentConfig)config)) {
                    this.configs.set(index, config);
                    this.instances.set(index, this.newInstance(config));
                }
                boolean bl = false;
                return bl;
            }
            if (this.addBeforeExistingConfigs) {
                this.configs.add(0, config);
                this.instances.add(0, this.newInstance(config));
            } else {
                this.configs.add(config);
                this.instances.add(this.newInstance(config));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentType getInstance(String name) {
        CheckArg.isNotNull(name, "name");
        try {
            this.lock.lock();
            int index = this.findIndexOfMatchingConfiguration(name);
            ComponentType ComponentType = index >= 0 ? (ComponentType)this.instances.get(index) : null;
            return ComponentType;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean update(ConfigType config) {
        return this.add(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ConfigType config) {
        CheckArg.isNotNull(config, "component configuration");
        try {
            this.lock.lock();
            int index = this.findIndexOfMatchingConfiguration(config);
            if (index >= 0) {
                this.configs.remove(index);
                this.instances.remove(index);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshInstances() {
        try {
            this.lock.lock();
            boolean found = false;
            int index = 0;
            for (ComponentConfig config : this.configs) {
                ComponentType instance = this.newInstance(config);
                found = found || instance != null;
                this.instances.set(index, instance);
                ++index;
            }
            boolean bl = found;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<ComponentType> getInstances() {
        return this.unmodifiableInstances;
    }

    protected ComponentType newInstance(ConfigType config) {
        String[] classpath = ((ComponentConfig)config).getComponentClasspathArray();
        ClassLoader classLoader = this.getClassLoaderFactory().getClassLoader(classpath);
        assert (classLoader != null);
        Object newInstance = null;
        try {
            Class<?> componentClass = Class.forName(((ComponentConfig)config).getComponentClassname(), true, classLoader);
            newInstance = this.doCreateInstance(componentClass);
            if (newInstance instanceof Component) {
                ((Component)newInstance).setConfiguration(config);
            }
            if (((ComponentConfig)config).getProperties() != null) {
                for (Map.Entry<String, Object> entry : ((ComponentConfig)config).getProperties().entrySet()) {
                    Reflection reflection = new Reflection(newInstance.getClass());
                    reflection.invokeSetterMethodOnTarget(entry.getKey(), newInstance, entry.getValue());
                }
            }
        }
        catch (Throwable e) {
            throw new SystemFailureException(e);
        }
        if (newInstance instanceof Component && ((Component)newInstance).getConfiguration() == null) {
            throw new SystemFailureException(CommonI18n.componentNotConfigured.text(((ComponentConfig)config).getName()));
        }
        return (ComponentType)newInstance;
    }

    protected ComponentType doCreateInstance(Class<?> componentClass) throws InstantiationException, IllegalAccessException {
        return (ComponentType)componentClass.newInstance();
    }

    @GuardedBy(value="lock")
    protected int findIndexOfMatchingConfiguration(ConfigType config) {
        int length = this.configs.size();
        for (int i = 0; i != length; ++i) {
            ComponentConfig existingConfig = (ComponentConfig)this.configs.get(i);
            assert (existingConfig != null);
            if (!existingConfig.equals(config)) continue;
            return i;
        }
        return -1;
    }

    @GuardedBy(value="lock")
    protected int findIndexOfMatchingConfiguration(String name) {
        int length = this.configs.size();
        for (int i = 0; i != length; ++i) {
            ComponentConfig existingConfig = (ComponentConfig)this.configs.get(i);
            assert (existingConfig != null);
            if (!existingConfig.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }
}

