/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.math;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Random;
import net.jcip.annotations.Immutable;
import org.modeshape.common.math.MathOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class IntegerOperations
implements MathOperations<Integer>,
Comparator<Integer> {
    @Override
    public Class<Integer> getOperandClass() {
        return Integer.class;
    }

    @Override
    public Integer add(Integer value1, Integer value2) {
        if (value1 == null) {
            return value2 != null ? value2 : this.createZeroValue();
        }
        if (value2 == null) {
            return value1;
        }
        return value1 + value2;
    }

    @Override
    public Integer subtract(Integer value1, Integer value2) {
        if (value1 == null) {
            return this.negate(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return value1 - value2;
    }

    @Override
    public Integer multiply(Integer value1, Integer value2) {
        if (value1 == null || value2 == null) {
            return this.createZeroValue();
        }
        return value1 * value2;
    }

    @Override
    public double divide(Integer value1, Integer value2) {
        if (value1 == null || value2 == null) {
            throw new IllegalArgumentException();
        }
        return value1 / value2;
    }

    @Override
    public Integer negate(Integer value) {
        if (value == null) {
            return this.createZeroValue();
        }
        return value * -1;
    }

    @Override
    public Integer increment(Integer value) {
        if (value == null) {
            return this.createZeroValue();
        }
        return value + 1;
    }

    @Override
    public Integer maximum(Integer value1, Integer value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return Math.max(value1, value2);
    }

    @Override
    public Integer minimum(Integer value1, Integer value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return Math.min(value1, value2);
    }

    @Override
    public int compare(Integer value1, Integer value2) {
        if (value1 == null) {
            return value2 != null ? -1 : 0;
        }
        if (value2 == null) {
            return 1;
        }
        return value1.compareTo(value2);
    }

    @Override
    public BigDecimal asBigDecimal(Integer value) {
        return value != null ? new BigDecimal(value) : null;
    }

    @Override
    public Integer fromBigDecimal(BigDecimal value) {
        return value != null ? Integer.valueOf(value.intValue()) : null;
    }

    @Override
    public Integer createZeroValue() {
        return 0;
    }

    @Override
    public Integer create(int value) {
        return value;
    }

    @Override
    public Integer create(long value) {
        return (int)value;
    }

    @Override
    public Integer create(double value) {
        return (int)value;
    }

    @Override
    public double sqrt(Integer value) {
        return Math.sqrt(value.intValue());
    }

    @Override
    public Comparator<Integer> getComparator() {
        return this;
    }

    @Override
    public Integer random(Integer minimum, Integer maximum, Random rng) {
        Integer difference = this.subtract(maximum, minimum);
        return minimum + rng.nextInt(difference);
    }

    @Override
    public double doubleValue(Integer value) {
        return value.doubleValue();
    }

    @Override
    public float floatValue(Integer value) {
        return value.floatValue();
    }

    @Override
    public int intValue(Integer value) {
        return value;
    }

    @Override
    public long longValue(Integer value) {
        return value.longValue();
    }

    @Override
    public short shortValue(Integer value) {
        return value.shortValue();
    }

    @Override
    public int getExponentInScientificNotation(Integer value) {
        int v = Math.abs(value);
        int exp = 0;
        if (v > 1) {
            while (v >= 10) {
                v /= 10;
                ++exp;
            }
        }
        return exp;
    }

    @Override
    public Integer roundUp(Integer value, int decimalShift) {
        if (value == 0) {
            return 0;
        }
        if (decimalShift >= 0) {
            return value;
        }
        int shiftedValueP5 = Math.abs(value);
        for (int i = 0; i != -decimalShift - 1; ++i) {
            shiftedValueP5 /= 10;
        }
        int shiftedValue = (shiftedValueP5 = (int)((long)shiftedValueP5 + 5L)) / 10;
        if ((long)shiftedValue * 10L - (long)shiftedValueP5 >= 5L) {
            ++shiftedValue;
        }
        shiftedValue *= Long.signum(value.intValue());
        for (int i = 0; i != -decimalShift; ++i) {
            shiftedValue *= 10;
        }
        return shiftedValue;
    }

    @Override
    public Integer roundDown(Integer value, int decimalShift) {
        int i;
        if (value == 0) {
            return 0;
        }
        if (decimalShift >= 0) {
            return value;
        }
        int shiftedValue = Math.abs(value);
        for (i = 0; i != -decimalShift; ++i) {
            shiftedValue /= 10;
        }
        shiftedValue *= Long.signum(value.intValue());
        for (i = 0; i != -decimalShift; ++i) {
            shiftedValue *= 10;
        }
        return shiftedValue;
    }

    @Override
    public Integer keepSignificantFigures(Integer value, int numSigFigs) {
        if (numSigFigs < 0) {
            return value;
        }
        if (numSigFigs == 0) {
            return 0;
        }
        int currentExp = this.getExponentInScientificNotation(value);
        int decimalShift = -currentExp + numSigFigs - 1;
        return this.roundUp(value, decimalShift);
    }
}

