/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.math;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Random;
import net.jcip.annotations.Immutable;
import org.modeshape.common.math.MathOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ShortOperations
implements MathOperations<Short>,
Comparator<Short> {
    @Override
    public Class<Short> getOperandClass() {
        return Short.class;
    }

    @Override
    public Short add(Short value1, Short value2) {
        if (value1 == null) {
            return value2 != null ? value2 : this.createZeroValue();
        }
        if (value2 == null) {
            return value1;
        }
        return (short)(value1 + value2);
    }

    @Override
    public Short subtract(Short value1, Short value2) {
        if (value1 == null) {
            return this.negate(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return (short)(value1 - value2);
    }

    @Override
    public Short multiply(Short value1, Short value2) {
        if (value1 == null || value2 == null) {
            return this.createZeroValue();
        }
        return (short)(value1 * value2);
    }

    @Override
    public double divide(Short value1, Short value2) {
        if (value1 == null || value2 == null) {
            throw new IllegalArgumentException();
        }
        return value1 / value2;
    }

    @Override
    public Short negate(Short value) {
        if (value == null) {
            return this.createZeroValue();
        }
        return (short)(value * -1);
    }

    @Override
    public Short increment(Short value) {
        if (value == null) {
            return this.createZeroValue();
        }
        return (short)(value + 1);
    }

    @Override
    public Short maximum(Short value1, Short value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return (short)Math.max(value1.shortValue(), value2.shortValue());
    }

    @Override
    public Short minimum(Short value1, Short value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return (short)Math.min(value1.shortValue(), value2.shortValue());
    }

    @Override
    public int compare(Short value1, Short value2) {
        if (value1 == null) {
            return value2 != null ? -1 : 0;
        }
        if (value2 == null) {
            return 1;
        }
        return value1.compareTo(value2);
    }

    @Override
    public BigDecimal asBigDecimal(Short value) {
        return value != null ? new BigDecimal(value.shortValue()) : null;
    }

    @Override
    public Short fromBigDecimal(BigDecimal value) {
        return value != null ? Short.valueOf(value.shortValue()) : null;
    }

    @Override
    public Short createZeroValue() {
        return (short)0;
    }

    @Override
    public Short create(int value) {
        return (short)value;
    }

    @Override
    public Short create(long value) {
        return (short)value;
    }

    @Override
    public Short create(double value) {
        return (short)value;
    }

    @Override
    public double sqrt(Short value) {
        return Math.sqrt(value.shortValue());
    }

    @Override
    public Comparator<Short> getComparator() {
        return this;
    }

    @Override
    public Short random(Short minimum, Short maximum, Random rng) {
        Short difference = this.subtract(maximum, minimum);
        int increment = rng.nextInt(difference.intValue());
        return new Integer(minimum + increment).shortValue();
    }

    @Override
    public double doubleValue(Short value) {
        return value.doubleValue();
    }

    @Override
    public float floatValue(Short value) {
        return value.floatValue();
    }

    @Override
    public int intValue(Short value) {
        return value.intValue();
    }

    @Override
    public long longValue(Short value) {
        return value.longValue();
    }

    @Override
    public short shortValue(Short value) {
        return value;
    }

    @Override
    public int getExponentInScientificNotation(Short value) {
        int exp;
        block3: {
            int v;
            block2: {
                v = Math.abs(value.shortValue());
                exp = 0;
                if (v <= 1) break block2;
                while (v >= 10) {
                    v /= 10;
                    ++exp;
                }
                break block3;
            }
            if (v >= 1) break block3;
            while (v < 1) {
                v *= 10;
                --exp;
            }
        }
        return exp;
    }

    @Override
    public Short roundUp(Short value, int decimalShift) {
        if (value == 0) {
            return (short)0;
        }
        if (decimalShift >= 0) {
            return value;
        }
        int shiftedValueP5 = Math.abs(value.shortValue());
        for (int i = 0; i != -decimalShift - 1; ++i) {
            shiftedValueP5 /= 10;
        }
        int shiftedValue = (shiftedValueP5 = (int)((long)shiftedValueP5 + 5L)) / 10;
        if ((long)shiftedValue * 10L - (long)shiftedValueP5 >= 5L) {
            ++shiftedValue;
        }
        shiftedValue *= Long.signum(value.shortValue());
        for (int i = 0; i != -decimalShift; ++i) {
            shiftedValue *= 10;
        }
        return (short)shiftedValue;
    }

    @Override
    public Short roundDown(Short value, int decimalShift) {
        int i;
        if (value == 0) {
            return (short)0;
        }
        if (decimalShift >= 0) {
            return value;
        }
        int shiftedValue = Math.abs(value.shortValue());
        for (i = 0; i != -decimalShift; ++i) {
            shiftedValue /= 10;
        }
        shiftedValue *= Long.signum(value.shortValue());
        for (i = 0; i != -decimalShift; ++i) {
            shiftedValue *= 10;
        }
        return (short)shiftedValue;
    }

    @Override
    public Short keepSignificantFigures(Short value, int numSigFigs) {
        if (numSigFigs < 0) {
            return value;
        }
        if (numSigFigs == 0) {
            return (short)0;
        }
        int currentExp = this.getExponentInScientificNotation(value);
        int decimalShift = -currentExp + numSigFigs - 1;
        return this.roundUp(value, decimalShift);
    }
}

