/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.text;

import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;

@Immutable
public class XmlValueEncoder
implements TextEncoder,
TextDecoder {
    private static final Map<String, Character> SPECIAL_ENTITIES = new HashMap<String, Character>();

    public String encode(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(text);
        char c = iter.first();
        while (c != '\uffff') {
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\'': {
                    sb.append("&#039;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            c = iter.next();
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public String decode(String encodedText) {
        if (encodedText == null) {
            return null;
        }
        sb = new StringBuilder();
        iter = new StringCharacterIterator(encodedText);
        c = iter.first();
        while (c != 65535) {
            block8: {
                if (c != 38) ** GOTO lbl27
                index = iter.getIndex();
                while ((c = iter.next()) != 65535 && c != 59) {
                }
                if (c != 59) ** GOTO lbl24
                s = encodedText.substring(index + 1, iter.getIndex());
                if (XmlValueEncoder.SPECIAL_ENTITIES.containsKey(s)) {
                    sb.append(XmlValueEncoder.SPECIAL_ENTITIES.get(s));
                } else {
                    if (s.length() > 0 && s.charAt(0) == '#') {
                        try {
                            sb.append((char)Short.parseShort(s.substring(1, s.length())));
                            break block8;
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                    }
lbl24:
                    // 4 sources

                    c = 38;
                    iter.setIndex(index);
lbl27:
                    // 2 sources

                    sb.append((char)c);
                }
            }
            c = iter.next();
        }
        return sb.toString();
    }

    static {
        SPECIAL_ENTITIES.put("quot", Character.valueOf('\"'));
        SPECIAL_ENTITIES.put("gt", Character.valueOf('>'));
        SPECIAL_ENTITIES.put("lt", Character.valueOf('<'));
        SPECIAL_ENTITIES.put("amp", Character.valueOf('&'));
    }
}

