/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.math;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Random;
import net.jcip.annotations.Immutable;

@Immutable
public interface MathOperations<T> {
    public Class<T> getOperandClass();

    public T add(T var1, T var2);

    public T subtract(T var1, T var2);

    public T multiply(T var1, T var2);

    public double divide(T var1, T var2);

    public T negate(T var1);

    public T increment(T var1);

    public T maximum(T var1, T var2);

    public T minimum(T var1, T var2);

    public int compare(T var1, T var2);

    public BigDecimal asBigDecimal(T var1);

    public T fromBigDecimal(BigDecimal var1);

    public double doubleValue(T var1);

    public float floatValue(T var1);

    public int intValue(T var1);

    public short shortValue(T var1);

    public long longValue(T var1);

    public T createZeroValue();

    public T create(int var1);

    public T create(long var1);

    public T create(double var1);

    public double sqrt(T var1);

    public Comparator<T> getComparator();

    public int getExponentInScientificNotation(T var1);

    public T roundUp(T var1, int var2);

    public T roundDown(T var1, int var2);

    public T keepSignificantFigures(T var1, int var2);

    public T random(T var1, T var2, Random var3);
}

